package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class StorageInfo(
    ebsStorageInfo: Option[zio.aws.kafka.model.EBSStorageInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.StorageInfo = {
    import StorageInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.StorageInfo
      .builder()
      .optionallyWith(ebsStorageInfo.map(value => value.buildAwsValue()))(
        _.ebsStorageInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.StorageInfo.ReadOnly =
    zio.aws.kafka.model.StorageInfo.wrap(buildAwsValue())
}
object StorageInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.StorageInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.StorageInfo = zio.aws.kafka.model
      .StorageInfo(ebsStorageInfo.map(value => value.asEditable))
    def ebsStorageInfo: Option[zio.aws.kafka.model.EBSStorageInfo.ReadOnly]
    def getEbsStorageInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EBSStorageInfo.ReadOnly] =
      AwsError.unwrapOptionField("ebsStorageInfo", ebsStorageInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.StorageInfo
  ) extends zio.aws.kafka.model.StorageInfo.ReadOnly {
    override val ebsStorageInfo
        : Option[zio.aws.kafka.model.EBSStorageInfo.ReadOnly] = scala
      .Option(impl.ebsStorageInfo())
      .map(value => zio.aws.kafka.model.EBSStorageInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.StorageInfo
  ): zio.aws.kafka.model.StorageInfo.ReadOnly = new Wrapper(impl)
}
