package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Tls(
    certificateAuthorityArnList: Option[Iterable[__string]] = None,
    enabled: Option[__boolean] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Tls = {
    import Tls.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Tls
      .builder()
      .optionallyWith(
        certificateAuthorityArnList.map(value =>
          value.map { item =>
            __string.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAuthorityArnList)
      .optionallyWith(
        enabled.map(value => __boolean.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Tls.ReadOnly =
    zio.aws.kafka.model.Tls.wrap(buildAwsValue())
}
object Tls {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Tls] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Tls = zio.aws.kafka.model.Tls(
      certificateAuthorityArnList.map(value => value),
      enabled.map(value => value)
    )
    def certificateAuthorityArnList: Option[List[__string]]
    def enabled: Option[__boolean]
    def getCertificateAuthorityArnList: ZIO[Any, AwsError, List[__string]] =
      AwsError.unwrapOptionField(
        "certificateAuthorityArnList",
        certificateAuthorityArnList
      )
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Tls
  ) extends zio.aws.kafka.model.Tls.ReadOnly {
    override val certificateAuthorityArnList: Option[List[__string]] = scala
      .Option(impl.certificateAuthorityArnList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafka.model.primitives.__string(item)
        }.toList
      )
    override val enabled: Option[__boolean] = scala
      .Option(impl.enabled())
      .map(value => zio.aws.kafka.model.primitives.__boolean(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Tls
  ): zio.aws.kafka.model.Tls.ReadOnly = new Wrapper(impl)
}
