package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdateClusterKafkaVersionRequest(
    clusterArn: __string,
    configurationInfo: Option[zio.aws.kafka.model.ConfigurationInfo] = None,
    currentVersion: __string,
    targetKafkaVersion: __string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest = {
    import UpdateClusterKafkaVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest
      .builder()
      .clusterArn(__string.unwrap(clusterArn): java.lang.String)
      .optionallyWith(configurationInfo.map(value => value.buildAwsValue()))(
        _.configurationInfo
      )
      .currentVersion(__string.unwrap(currentVersion): java.lang.String)
      .targetKafkaVersion(__string.unwrap(targetKafkaVersion): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.UpdateClusterKafkaVersionRequest.ReadOnly =
    zio.aws.kafka.model.UpdateClusterKafkaVersionRequest.wrap(buildAwsValue())
}
object UpdateClusterKafkaVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateClusterKafkaVersionRequest =
      zio.aws.kafka.model.UpdateClusterKafkaVersionRequest(
        clusterArn,
        configurationInfo.map(value => value.asEditable),
        currentVersion,
        targetKafkaVersion
      )
    def clusterArn: __string
    def configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly]
    def currentVersion: __string
    def targetKafkaVersion: __string
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getConfigurationInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.ConfigurationInfo.ReadOnly] =
      AwsError.unwrapOptionField("configurationInfo", configurationInfo)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getTargetKafkaVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(targetKafkaVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest
  ) extends zio.aws.kafka.model.UpdateClusterKafkaVersionRequest.ReadOnly {
    override val clusterArn: __string =
      zio.aws.kafka.model.primitives.__string(impl.clusterArn())
    override val configurationInfo
        : Option[zio.aws.kafka.model.ConfigurationInfo.ReadOnly] = scala
      .Option(impl.configurationInfo())
      .map(value => zio.aws.kafka.model.ConfigurationInfo.wrap(value))
    override val currentVersion: __string =
      zio.aws.kafka.model.primitives.__string(impl.currentVersion())
    override val targetKafkaVersion: __string =
      zio.aws.kafka.model.primitives.__string(impl.targetKafkaVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateClusterKafkaVersionRequest
  ): zio.aws.kafka.model.UpdateClusterKafkaVersionRequest.ReadOnly =
    new Wrapper(impl)
}
