package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait ClientBroker {
  def unwrap: software.amazon.awssdk.services.kafka.model.ClientBroker
}
object ClientBroker {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.ClientBroker
  ): zio.aws.kafka.model.ClientBroker = value match {
    case software.amazon.awssdk.services.kafka.model.ClientBroker.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.ClientBroker.TLS =>
      val r = TLS
      r
    case software.amazon.awssdk.services.kafka.model.ClientBroker.TLS_PLAINTEXT =>
      val r = TLS_PLAINTEXT
      r
    case software.amazon.awssdk.services.kafka.model.ClientBroker.PLAINTEXT =>
      val r = PLAINTEXT
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.ClientBroker {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClientBroker =
      software.amazon.awssdk.services.kafka.model.ClientBroker.UNKNOWN_TO_SDK_VERSION
  }
  case object TLS extends zio.aws.kafka.model.ClientBroker {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClientBroker =
      software.amazon.awssdk.services.kafka.model.ClientBroker.TLS
  }
  case object TLS_PLAINTEXT extends zio.aws.kafka.model.ClientBroker {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClientBroker =
      software.amazon.awssdk.services.kafka.model.ClientBroker.TLS_PLAINTEXT
  }
  case object PLAINTEXT extends zio.aws.kafka.model.ClientBroker {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ClientBroker =
      software.amazon.awssdk.services.kafka.model.ClientBroker.PLAINTEXT
  }
}
