package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.{__boolean, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3(
    bucket: Optional[__string] = Optional.Absent,
    enabled: __boolean,
    prefix: Optional[__string] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.S3 = {
    import S3.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.S3
      .builder()
      .optionallyWith(bucket.map(value => value: java.lang.String))(_.bucket)
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(prefix.map(value => value: java.lang.String))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.S3.ReadOnly =
    zio.aws.kafka.model.S3.wrap(buildAwsValue())
}
object S3 {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.S3] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.S3 = zio.aws.kafka.model
      .S3(bucket.map(value => value), enabled, prefix.map(value => value))
    def bucket: Optional[__string]
    def enabled: __boolean
    def prefix: Optional[__string]
    def getBucket: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
    def getPrefix: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.S3
  ) extends zio.aws.kafka.model.S3.ReadOnly {
    override val bucket: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => value: __string)
    override val enabled: __boolean = impl.enabled(): __boolean
    override val prefix: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.S3
  ): zio.aws.kafka.model.S3.ReadOnly = new Wrapper(impl)
}
