package zio.aws.kafka
import zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.kafka.KafkaAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.kafka.model.primitives.__string
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.kafka.model.{
  BatchAssociateScramSecretRequest,
  UpdateClusterKafkaVersionRequest,
  GetBootstrapBrokersRequest,
  GetCompatibleKafkaVersionsRequest,
  UpdateBrokerTypeRequest,
  DescribeConfigurationRevisionRequest,
  ListNodesRequest,
  DeleteConfigurationRequest,
  DescribeConfigurationRequest,
  UpdateSecurityRequest,
  CreateClusterV2Request,
  UpdateStorageRequest,
  ListKafkaVersionsRequest,
  ListTagsForResourceRequest,
  UpdateConfigurationRequest,
  CreateClusterRequest,
  CreateConfigurationRequest,
  DeleteClusterRequest,
  ListClusterOperationsRequest,
  DescribeClusterV2Request,
  ListClustersV2Request,
  UpdateClusterConfigurationRequest,
  UntagResourceRequest,
  UpdateMonitoringRequest,
  UpdateBrokerStorageRequest,
  DescribeClusterRequest,
  ListConfigurationRevisionsRequest,
  RebootBrokerRequest,
  UpdateBrokerCountRequest,
  ListClustersRequest,
  DescribeClusterOperationRequest,
  TagResourceRequest,
  BatchDisassociateScramSecretRequest,
  UpdateConnectivityRequest,
  ListConfigurationsRequest,
  ListScramSecretsRequest
}
object KafkaMock extends Mock[Kafka] {
  object DescribeClusterV2
      extends Effect[
        DescribeClusterV2Request,
        AwsError,
        zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly
      ]
  object DeleteConfiguration
      extends Effect[
        DeleteConfigurationRequest,
        AwsError,
        zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly
      ]
  object BatchDisassociateScramSecret
      extends Effect[
        BatchDisassociateScramSecretRequest,
        AwsError,
        zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly
      ]
  object CreateConfiguration
      extends Effect[
        CreateConfigurationRequest,
        AwsError,
        zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly
      ]
  object BatchAssociateScramSecret
      extends Effect[
        BatchAssociateScramSecretRequest,
        AwsError,
        zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly
      ]
  object UpdateConfiguration
      extends Effect[
        UpdateConfigurationRequest,
        AwsError,
        zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly
      ]
  object RebootBroker
      extends Effect[
        RebootBrokerRequest,
        AwsError,
        zio.aws.kafka.model.RebootBrokerResponse.ReadOnly
      ]
  object UpdateSecurity
      extends Effect[
        UpdateSecurityRequest,
        AwsError,
        zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly
      ]
  object GetBootstrapBrokers
      extends Effect[GetBootstrapBrokersRequest, AwsError, ReadOnly]
  object CreateCluster
      extends Effect[
        CreateClusterRequest,
        AwsError,
        zio.aws.kafka.model.CreateClusterResponse.ReadOnly
      ]
  object DeleteCluster
      extends Effect[
        DeleteClusterRequest,
        AwsError,
        zio.aws.kafka.model.DeleteClusterResponse.ReadOnly
      ]
  object ListClusterOperations
      extends Stream[
        ListClusterOperationsRequest,
        AwsError,
        zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
      ]
  object ListClusterOperationsPaginated
      extends Effect[
        ListClusterOperationsRequest,
        AwsError,
        zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly
      ]
  object UpdateBrokerType
      extends Effect[
        UpdateBrokerTypeRequest,
        AwsError,
        zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly
      ]
  object DescribeClusterOperation
      extends Effect[
        DescribeClusterOperationRequest,
        AwsError,
        zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly
      ]
  object ListConfigurations
      extends Stream[
        ListConfigurationsRequest,
        AwsError,
        zio.aws.kafka.model.Configuration.ReadOnly
      ]
  object ListConfigurationsPaginated
      extends Effect[
        ListConfigurationsRequest,
        AwsError,
        zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly
      ]
  object CreateClusterV2
      extends Effect[
        CreateClusterV2Request,
        AwsError,
        zio.aws.kafka.model.CreateClusterV2Response.ReadOnly
      ]
  object ListScramSecrets
      extends Stream[ListScramSecretsRequest, AwsError, __string]
  object ListScramSecretsPaginated
      extends Effect[
        ListScramSecretsRequest,
        AwsError,
        zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly
      ]
  object UntagResource extends Effect[UntagResourceRequest, AwsError, Unit]
  object UpdateClusterKafkaVersion
      extends Effect[
        UpdateClusterKafkaVersionRequest,
        AwsError,
        zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.ReadOnly
      ]
  object UpdateStorage
      extends Effect[
        UpdateStorageRequest,
        AwsError,
        zio.aws.kafka.model.UpdateStorageResponse.ReadOnly
      ]
  object DescribeConfiguration
      extends Effect[
        DescribeConfigurationRequest,
        AwsError,
        zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly
      ]
  object DescribeCluster
      extends Effect[
        DescribeClusterRequest,
        AwsError,
        zio.aws.kafka.model.DescribeClusterResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.kafka.model.ListTagsForResourceResponse.ReadOnly
      ]
  object ListClusters
      extends Stream[
        ListClustersRequest,
        AwsError,
        zio.aws.kafka.model.ClusterInfo.ReadOnly
      ]
  object ListClustersPaginated
      extends Effect[
        ListClustersRequest,
        AwsError,
        zio.aws.kafka.model.ListClustersResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, Unit]
  object GetCompatibleKafkaVersions
      extends Effect[
        GetCompatibleKafkaVersionsRequest,
        AwsError,
        zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly
      ]
  object UpdateClusterConfiguration
      extends Effect[
        UpdateClusterConfigurationRequest,
        AwsError,
        zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly
      ]
  object UpdateConnectivity
      extends Effect[
        UpdateConnectivityRequest,
        AwsError,
        zio.aws.kafka.model.UpdateConnectivityResponse.ReadOnly
      ]
  object UpdateBrokerCount
      extends Effect[
        UpdateBrokerCountRequest,
        AwsError,
        zio.aws.kafka.model.UpdateBrokerCountResponse.ReadOnly
      ]
  object DescribeConfigurationRevision
      extends Effect[
        DescribeConfigurationRevisionRequest,
        AwsError,
        zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly
      ]
  object UpdateBrokerStorage
      extends Effect[
        UpdateBrokerStorageRequest,
        AwsError,
        zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly
      ]
  object ListKafkaVersions
      extends Stream[
        ListKafkaVersionsRequest,
        AwsError,
        zio.aws.kafka.model.KafkaVersion.ReadOnly
      ]
  object ListKafkaVersionsPaginated
      extends Effect[
        ListKafkaVersionsRequest,
        AwsError,
        zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly
      ]
  object ListConfigurationRevisions
      extends Stream[
        ListConfigurationRevisionsRequest,
        AwsError,
        zio.aws.kafka.model.ConfigurationRevision.ReadOnly
      ]
  object ListConfigurationRevisionsPaginated
      extends Effect[
        ListConfigurationRevisionsRequest,
        AwsError,
        zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly
      ]
  object UpdateMonitoring
      extends Effect[
        UpdateMonitoringRequest,
        AwsError,
        zio.aws.kafka.model.UpdateMonitoringResponse.ReadOnly
      ]
  object ListNodes
      extends Stream[
        ListNodesRequest,
        AwsError,
        zio.aws.kafka.model.NodeInfo.ReadOnly
      ]
  object ListNodesPaginated
      extends Effect[
        ListNodesRequest,
        AwsError,
        zio.aws.kafka.model.ListNodesResponse.ReadOnly
      ]
  object ListClustersV2
      extends Stream[
        ListClustersV2Request,
        AwsError,
        zio.aws.kafka.model.Cluster.ReadOnly
      ]
  object ListClustersV2Paginated
      extends Effect[
        ListClustersV2Request,
        AwsError,
        zio.aws.kafka.model.ListClustersV2Response.ReadOnly
      ]
  val compose: URLayer[Proxy, Kafka] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Kafka] { rts =>
        zio.ZIO.succeed {
          new Kafka {
            val api: KafkaAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Kafka = this
            def describeClusterV2(request: DescribeClusterV2Request): IO[
              AwsError,
              zio.aws.kafka.model.DescribeClusterV2Response.ReadOnly
            ] = proxy(DescribeClusterV2, request)
            def deleteConfiguration(request: DeleteConfigurationRequest): IO[
              AwsError,
              zio.aws.kafka.model.DeleteConfigurationResponse.ReadOnly
            ] = proxy(DeleteConfiguration, request)
            def batchDisassociateScramSecret(
                request: BatchDisassociateScramSecretRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.BatchDisassociateScramSecretResponse.ReadOnly
            ] = proxy(BatchDisassociateScramSecret, request)
            def createConfiguration(request: CreateConfigurationRequest): IO[
              AwsError,
              zio.aws.kafka.model.CreateConfigurationResponse.ReadOnly
            ] = proxy(CreateConfiguration, request)
            def batchAssociateScramSecret(
                request: BatchAssociateScramSecretRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly
            ] = proxy(BatchAssociateScramSecret, request)
            def updateConfiguration(request: UpdateConfigurationRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateConfigurationResponse.ReadOnly
            ] = proxy(UpdateConfiguration, request)
            def rebootBroker(
                request: RebootBrokerRequest
            ): IO[AwsError, zio.aws.kafka.model.RebootBrokerResponse.ReadOnly] =
              proxy(RebootBroker, request)
            def updateSecurity(request: UpdateSecurityRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly
            ] = proxy(UpdateSecurity, request)
            def getBootstrapBrokers(
                request: GetBootstrapBrokersRequest
            ): IO[AwsError, ReadOnly] = proxy(GetBootstrapBrokers, request)
            def createCluster(request: CreateClusterRequest): IO[
              AwsError,
              zio.aws.kafka.model.CreateClusterResponse.ReadOnly
            ] = proxy(CreateCluster, request)
            def deleteCluster(request: DeleteClusterRequest): IO[
              AwsError,
              zio.aws.kafka.model.DeleteClusterResponse.ReadOnly
            ] = proxy(DeleteCluster, request)
            def listClusterOperations(
                request: ListClusterOperationsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kafka.model.ClusterOperationInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClusterOperations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClusterOperationsPaginated(
                request: ListClusterOperationsRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.ListClusterOperationsResponse.ReadOnly
            ] = proxy(ListClusterOperationsPaginated, request)
            def updateBrokerType(request: UpdateBrokerTypeRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly
            ] = proxy(UpdateBrokerType, request)
            def describeClusterOperation(
                request: DescribeClusterOperationRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.DescribeClusterOperationResponse.ReadOnly
            ] = proxy(DescribeClusterOperation, request)
            def listConfigurations(request: ListConfigurationsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kafka.model.Configuration.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConfigurations, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConfigurationsPaginated(
                request: ListConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly
            ] = proxy(ListConfigurationsPaginated, request)
            def createClusterV2(request: CreateClusterV2Request): IO[
              AwsError,
              zio.aws.kafka.model.CreateClusterV2Response.ReadOnly
            ] = proxy(CreateClusterV2, request)
            def listScramSecrets(
                request: ListScramSecretsRequest
            ): ZStream[Any, AwsError, __string] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListScramSecrets, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listScramSecretsPaginated(request: ListScramSecretsRequest): IO[
              AwsError,
              zio.aws.kafka.model.ListScramSecretsResponse.ReadOnly
            ] = proxy(ListScramSecretsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, Unit] = proxy(UntagResource, request)
            def updateClusterKafkaVersion(
                request: UpdateClusterKafkaVersionRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.UpdateClusterKafkaVersionResponse.ReadOnly
            ] = proxy(UpdateClusterKafkaVersion, request)
            def updateStorage(request: UpdateStorageRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateStorageResponse.ReadOnly
            ] = proxy(UpdateStorage, request)
            def describeConfiguration(
                request: DescribeConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.DescribeConfigurationResponse.ReadOnly
            ] = proxy(DescribeConfiguration, request)
            def describeCluster(request: DescribeClusterRequest): IO[
              AwsError,
              zio.aws.kafka.model.DescribeClusterResponse.ReadOnly
            ] = proxy(DescribeCluster, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.kafka.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def listClusters(request: ListClustersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kafka.model.ClusterInfo.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListClusters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listClustersPaginated(
                request: ListClustersRequest
            ): IO[AwsError, zio.aws.kafka.model.ListClustersResponse.ReadOnly] =
              proxy(ListClustersPaginated, request)
            def tagResource(request: TagResourceRequest): IO[AwsError, Unit] =
              proxy(TagResource, request)
            def getCompatibleKafkaVersions(
                request: GetCompatibleKafkaVersionsRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.GetCompatibleKafkaVersionsResponse.ReadOnly
            ] = proxy(GetCompatibleKafkaVersions, request)
            def updateClusterConfiguration(
                request: UpdateClusterConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.UpdateClusterConfigurationResponse.ReadOnly
            ] = proxy(UpdateClusterConfiguration, request)
            def updateConnectivity(request: UpdateConnectivityRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateConnectivityResponse.ReadOnly
            ] = proxy(UpdateConnectivity, request)
            def updateBrokerCount(request: UpdateBrokerCountRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateBrokerCountResponse.ReadOnly
            ] = proxy(UpdateBrokerCount, request)
            def describeConfigurationRevision(
                request: DescribeConfigurationRevisionRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.DescribeConfigurationRevisionResponse.ReadOnly
            ] = proxy(DescribeConfigurationRevision, request)
            def updateBrokerStorage(request: UpdateBrokerStorageRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateBrokerStorageResponse.ReadOnly
            ] = proxy(UpdateBrokerStorage, request)
            def listKafkaVersions(request: ListKafkaVersionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.kafka.model.KafkaVersion.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListKafkaVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listKafkaVersionsPaginated(
                request: ListKafkaVersionsRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly
            ] = proxy(ListKafkaVersionsPaginated, request)
            def listConfigurationRevisions(
                request: ListConfigurationRevisionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.kafka.model.ConfigurationRevision.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListConfigurationRevisions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listConfigurationRevisionsPaginated(
                request: ListConfigurationRevisionsRequest
            ): IO[
              AwsError,
              zio.aws.kafka.model.ListConfigurationRevisionsResponse.ReadOnly
            ] = proxy(ListConfigurationRevisionsPaginated, request)
            def updateMonitoring(request: UpdateMonitoringRequest): IO[
              AwsError,
              zio.aws.kafka.model.UpdateMonitoringResponse.ReadOnly
            ] = proxy(UpdateMonitoring, request)
            def listNodes(
                request: ListNodesRequest
            ): ZStream[Any, AwsError, zio.aws.kafka.model.NodeInfo.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListNodes, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listNodesPaginated(
                request: ListNodesRequest
            ): IO[AwsError, zio.aws.kafka.model.ListNodesResponse.ReadOnly] =
              proxy(ListNodesPaginated, request)
            def listClustersV2(
                request: ListClustersV2Request
            ): ZStream[Any, AwsError, zio.aws.kafka.model.Cluster.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListClustersV2, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listClustersV2Paginated(request: ListClustersV2Request): IO[
              AwsError,
              zio.aws.kafka.model.ListClustersV2Response.ReadOnly
            ] = proxy(ListClustersV2Paginated, request)
          }
        }
      }
    }
  }
}
