package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait ConfigurationState {
  def unwrap: software.amazon.awssdk.services.kafka.model.ConfigurationState
}
object ConfigurationState {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.ConfigurationState
  ): zio.aws.kafka.model.ConfigurationState = value match {
    case software.amazon.awssdk.services.kafka.model.ConfigurationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.ConfigurationState.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.kafka.model.ConfigurationState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.kafka.model.ConfigurationState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kafka.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ConfigurationState =
      software.amazon.awssdk.services.kafka.model.ConfigurationState.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.kafka.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ConfigurationState =
      software.amazon.awssdk.services.kafka.model.ConfigurationState.ACTIVE
  }
  case object DELETING extends zio.aws.kafka.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ConfigurationState =
      software.amazon.awssdk.services.kafka.model.ConfigurationState.DELETING
  }
  case object DELETE_FAILED extends zio.aws.kafka.model.ConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.ConfigurationState =
      software.amazon.awssdk.services.kafka.model.ConfigurationState.DELETE_FAILED
  }
}
