package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.__integerMin1Max16384
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class EBSStorageInfo(
    provisionedThroughput: Optional[zio.aws.kafka.model.ProvisionedThroughput] =
      Optional.Absent,
    volumeSize: Optional[__integerMin1Max16384] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.EBSStorageInfo = {
    import EBSStorageInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.EBSStorageInfo
      .builder()
      .optionallyWith(
        provisionedThroughput.map(value => value.buildAwsValue())
      )(_.provisionedThroughput)
      .optionallyWith(volumeSize.map(value => value: Integer))(_.volumeSize)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.EBSStorageInfo.ReadOnly =
    zio.aws.kafka.model.EBSStorageInfo.wrap(buildAwsValue())
}
object EBSStorageInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.EBSStorageInfo =
      zio.aws.kafka.model.EBSStorageInfo(
        provisionedThroughput.map(value => value.asEditable),
        volumeSize.map(value => value)
      )
    def provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly]
    def volumeSize: Optional[__integerMin1Max16384]
    def getProvisionedThroughput: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ProvisionedThroughput.ReadOnly
    ] =
      AwsError.unwrapOptionField("provisionedThroughput", provisionedThroughput)
    def getVolumeSize: ZIO[Any, AwsError, __integerMin1Max16384] =
      AwsError.unwrapOptionField("volumeSize", volumeSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ) extends zio.aws.kafka.model.EBSStorageInfo.ReadOnly {
    override val provisionedThroughput
        : Optional[zio.aws.kafka.model.ProvisionedThroughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.provisionedThroughput())
        .map(value => zio.aws.kafka.model.ProvisionedThroughput.wrap(value))
    override val volumeSize: Optional[__integerMin1Max16384] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeSize())
        .map(value => value: __integerMin1Max16384)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.EBSStorageInfo
  ): zio.aws.kafka.model.EBSStorageInfo.ReadOnly = new Wrapper(impl)
}
