package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetBootstrapBrokersResponse(
    bootstrapBrokerString: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringTls: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringSaslScram: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringSaslIam: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringPublicTls: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringPublicSaslScram: Optional[__string] = Optional.Absent,
    bootstrapBrokerStringPublicSaslIam: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse = {
    import GetBootstrapBrokersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
      .builder()
      .optionallyWith(
        bootstrapBrokerString.map(value => value: java.lang.String)
      )(_.bootstrapBrokerString)
      .optionallyWith(
        bootstrapBrokerStringTls.map(value => value: java.lang.String)
      )(_.bootstrapBrokerStringTls)
      .optionallyWith(
        bootstrapBrokerStringSaslScram.map(value => value: java.lang.String)
      )(_.bootstrapBrokerStringSaslScram)
      .optionallyWith(
        bootstrapBrokerStringSaslIam.map(value => value: java.lang.String)
      )(_.bootstrapBrokerStringSaslIam)
      .optionallyWith(
        bootstrapBrokerStringPublicTls.map(value => value: java.lang.String)
      )(_.bootstrapBrokerStringPublicTls)
      .optionallyWith(
        bootstrapBrokerStringPublicSaslScram.map(value =>
          value: java.lang.String
        )
      )(_.bootstrapBrokerStringPublicSaslScram)
      .optionallyWith(
        bootstrapBrokerStringPublicSaslIam.map(value => value: java.lang.String)
      )(_.bootstrapBrokerStringPublicSaslIam)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly =
    zio.aws.kafka.model.GetBootstrapBrokersResponse.wrap(buildAwsValue())
}
object GetBootstrapBrokersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.GetBootstrapBrokersResponse =
      zio.aws.kafka.model.GetBootstrapBrokersResponse(
        bootstrapBrokerString.map(value => value),
        bootstrapBrokerStringTls.map(value => value),
        bootstrapBrokerStringSaslScram.map(value => value),
        bootstrapBrokerStringSaslIam.map(value => value),
        bootstrapBrokerStringPublicTls.map(value => value),
        bootstrapBrokerStringPublicSaslScram.map(value => value),
        bootstrapBrokerStringPublicSaslIam.map(value => value)
      )
    def bootstrapBrokerString: Optional[__string]
    def bootstrapBrokerStringTls: Optional[__string]
    def bootstrapBrokerStringSaslScram: Optional[__string]
    def bootstrapBrokerStringSaslIam: Optional[__string]
    def bootstrapBrokerStringPublicTls: Optional[__string]
    def bootstrapBrokerStringPublicSaslScram: Optional[__string]
    def bootstrapBrokerStringPublicSaslIam: Optional[__string]
    def getBootstrapBrokerString: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bootstrapBrokerString", bootstrapBrokerString)
    def getBootstrapBrokerStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("bootstrapBrokerStringTls", bootstrapBrokerStringTls)
    def getBootstrapBrokerStringSaslScram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringSaslScram",
        bootstrapBrokerStringSaslScram
      )
    def getBootstrapBrokerStringSaslIam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringSaslIam",
        bootstrapBrokerStringSaslIam
      )
    def getBootstrapBrokerStringPublicTls: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicTls",
        bootstrapBrokerStringPublicTls
      )
    def getBootstrapBrokerStringPublicSaslScram: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicSaslScram",
        bootstrapBrokerStringPublicSaslScram
      )
    def getBootstrapBrokerStringPublicSaslIam: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField(
        "bootstrapBrokerStringPublicSaslIam",
        bootstrapBrokerStringPublicSaslIam
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ) extends zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly {
    override val bootstrapBrokerString: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerString())
        .map(value => value: __string)
    override val bootstrapBrokerStringTls: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringTls())
        .map(value => value: __string)
    override val bootstrapBrokerStringSaslScram: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringSaslScram())
        .map(value => value: __string)
    override val bootstrapBrokerStringSaslIam: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringSaslIam())
        .map(value => value: __string)
    override val bootstrapBrokerStringPublicTls: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringPublicTls())
        .map(value => value: __string)
    override val bootstrapBrokerStringPublicSaslScram: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringPublicSaslScram())
        .map(value => value: __string)
    override val bootstrapBrokerStringPublicSaslIam: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.bootstrapBrokerStringPublicSaslIam())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.GetBootstrapBrokersResponse
  ): zio.aws.kafka.model.GetBootstrapBrokersResponse.ReadOnly = new Wrapper(
    impl
  )
}
