package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListClustersRequest(
    clusterNameFilter: Optional[__string] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersRequest
      .builder()
      .optionallyWith(clusterNameFilter.map(value => value: java.lang.String))(
        _.clusterNameFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersRequest.ReadOnly =
    zio.aws.kafka.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersRequest =
      zio.aws.kafka.model.ListClustersRequest(
        clusterNameFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterNameFilter: Optional[__string]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getClusterNameFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterNameFilter", clusterNameFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ) extends zio.aws.kafka.model.ListClustersRequest.ReadOnly {
    override val clusterNameFilter: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterNameFilter())
      .map(value => value: __string)
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ): zio.aws.kafka.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
