package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListConfigurationsResponse(
    configurations: Optional[Iterable[zio.aws.kafka.model.Configuration]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse = {
    import ListConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse
      .builder()
      .optionallyWith(
        configurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly =
    zio.aws.kafka.model.ListConfigurationsResponse.wrap(buildAwsValue())
}
object ListConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListConfigurationsResponse =
      zio.aws.kafka.model.ListConfigurationsResponse(
        configurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurations
        : Optional[List[zio.aws.kafka.model.Configuration.ReadOnly]]
    def nextToken: Optional[__string]
    def getConfigurations
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.Configuration.ReadOnly]] =
      AwsError.unwrapOptionField("configurations", configurations)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse
  ) extends zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly {
    override val configurations
        : Optional[List[zio.aws.kafka.model.Configuration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.Configuration.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse
  ): zio.aws.kafka.model.ListConfigurationsResponse.ReadOnly = new Wrapper(impl)
}
