package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class OpenMonitoringInfo(
    prometheus: zio.aws.kafka.model.PrometheusInfo
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo = {
    import OpenMonitoringInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo
      .builder()
      .prometheus(prometheus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly =
    zio.aws.kafka.model.OpenMonitoringInfo.wrap(buildAwsValue())
}
object OpenMonitoringInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.OpenMonitoringInfo =
      zio.aws.kafka.model.OpenMonitoringInfo(prometheus.asEditable)
    def prometheus: zio.aws.kafka.model.PrometheusInfo.ReadOnly
    def getPrometheus
        : ZIO[Any, Nothing, zio.aws.kafka.model.PrometheusInfo.ReadOnly] =
      ZIO.succeed(prometheus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo
  ) extends zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly {
    override val prometheus: zio.aws.kafka.model.PrometheusInfo.ReadOnly =
      zio.aws.kafka.model.PrometheusInfo.wrap(impl.prometheus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.OpenMonitoringInfo
  ): zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly = new Wrapper(impl)
}
