package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{__integerMin1Max15, __string}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateBrokerCountRequest(
    clusterArn: __string,
    currentVersion: __string,
    targetNumberOfBrokerNodes: __integerMin1Max15
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest = {
    import UpdateBrokerCountRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .currentVersion(currentVersion: java.lang.String)
      .targetNumberOfBrokerNodes(targetNumberOfBrokerNodes: Integer)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateBrokerCountRequest.ReadOnly =
    zio.aws.kafka.model.UpdateBrokerCountRequest.wrap(buildAwsValue())
}
object UpdateBrokerCountRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateBrokerCountRequest =
      zio.aws.kafka.model.UpdateBrokerCountRequest(
        clusterArn,
        currentVersion,
        targetNumberOfBrokerNodes
      )
    def clusterArn: __string
    def currentVersion: __string
    def targetNumberOfBrokerNodes: __integerMin1Max15
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getTargetNumberOfBrokerNodes: ZIO[Any, Nothing, __integerMin1Max15] =
      ZIO.succeed(targetNumberOfBrokerNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest
  ) extends zio.aws.kafka.model.UpdateBrokerCountRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: __string = impl.currentVersion(): __string
    override val targetNumberOfBrokerNodes: __integerMin1Max15 =
      impl.targetNumberOfBrokerNodes(): __integerMin1Max15
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerCountRequest
  ): zio.aws.kafka.model.UpdateBrokerCountRequest.ReadOnly = new Wrapper(impl)
}
