package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateSecurityResponse(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterOperationArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse = {
    import UpdateSecurityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterOperationArn.map(value => value: java.lang.String)
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly =
    zio.aws.kafka.model.UpdateSecurityResponse.wrap(buildAwsValue())
}
object UpdateSecurityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateSecurityResponse =
      zio.aws.kafka.model.UpdateSecurityResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Optional[__string]
    def clusterOperationArn: Optional[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ) extends zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterOperationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterOperationArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateSecurityResponse
  ): zio.aws.kafka.model.UpdateSecurityResponse.ReadOnly = new Wrapper(impl)
}
