package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchAssociateScramSecretResponse(
    clusterArn: Optional[__string] = Optional.Absent,
    unprocessedScramSecrets: Optional[
      Iterable[zio.aws.kafka.model.UnprocessedScramSecret]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse = {
    import BatchAssociateScramSecretResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        unprocessedScramSecrets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.unprocessedScramSecrets)
      .build()
  }
  def asReadOnly
      : zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly =
    zio.aws.kafka.model.BatchAssociateScramSecretResponse.wrap(buildAwsValue())
}
object BatchAssociateScramSecretResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.BatchAssociateScramSecretResponse =
      zio.aws.kafka.model.BatchAssociateScramSecretResponse(
        clusterArn.map(value => value),
        unprocessedScramSecrets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterArn: Optional[__string]
    def unprocessedScramSecrets
        : Optional[List[zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly]]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getUnprocessedScramSecrets: ZIO[Any, AwsError, List[
      zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "unprocessedScramSecrets",
      unprocessedScramSecrets
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse
  ) extends zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val unprocessedScramSecrets
        : Optional[List[zio.aws.kafka.model.UnprocessedScramSecret.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unprocessedScramSecrets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.UnprocessedScramSecret.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.BatchAssociateScramSecretResponse
  ): zio.aws.kafka.model.BatchAssociateScramSecretResponse.ReadOnly =
    new Wrapper(impl)
}
