package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateClusterV2Response(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterName: Optional[__string] = Optional.Absent,
    state: Optional[zio.aws.kafka.model.ClusterState] = Optional.Absent,
    clusterType: Optional[zio.aws.kafka.model.ClusterType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.CreateClusterV2Response = {
    import CreateClusterV2Response.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(clusterName.map(value => value: java.lang.String))(
        _.clusterName
      )
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(clusterType.map(value => value.unwrap))(_.clusterType)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.CreateClusterV2Response.ReadOnly =
    zio.aws.kafka.model.CreateClusterV2Response.wrap(buildAwsValue())
}
object CreateClusterV2Response {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.CreateClusterV2Response =
      zio.aws.kafka.model.CreateClusterV2Response(
        clusterArn.map(value => value),
        clusterName.map(value => value),
        state.map(value => value),
        clusterType.map(value => value)
      )
    def clusterArn: Optional[__string]
    def clusterName: Optional[__string]
    def state: Optional[zio.aws.kafka.model.ClusterState]
    def clusterType: Optional[zio.aws.kafka.model.ClusterType]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterName", clusterName)
    def getState: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterState] =
      AwsError.unwrapOptionField("state", state)
    def getClusterType: ZIO[Any, AwsError, zio.aws.kafka.model.ClusterType] =
      AwsError.unwrapOptionField("clusterType", clusterType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ) extends zio.aws.kafka.model.CreateClusterV2Response.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterName())
      .map(value => value: __string)
    override val state: Optional[zio.aws.kafka.model.ClusterState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.kafka.model.ClusterState.wrap(value))
    override val clusterType: Optional[zio.aws.kafka.model.ClusterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clusterType())
        .map(value => zio.aws.kafka.model.ClusterType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.CreateClusterV2Response
  ): zio.aws.kafka.model.CreateClusterV2Response.ReadOnly = new Wrapper(impl)
}
