package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EncryptionInfo(
    encryptionAtRest: Optional[zio.aws.kafka.model.EncryptionAtRest] =
      Optional.Absent,
    encryptionInTransit: Optional[zio.aws.kafka.model.EncryptionInTransit] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.EncryptionInfo = {
    import EncryptionInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.EncryptionInfo
      .builder()
      .optionallyWith(encryptionAtRest.map(value => value.buildAwsValue()))(
        _.encryptionAtRest
      )
      .optionallyWith(encryptionInTransit.map(value => value.buildAwsValue()))(
        _.encryptionInTransit
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.EncryptionInfo.ReadOnly =
    zio.aws.kafka.model.EncryptionInfo.wrap(buildAwsValue())
}
object EncryptionInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.EncryptionInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.EncryptionInfo =
      zio.aws.kafka.model.EncryptionInfo(
        encryptionAtRest.map(value => value.asEditable),
        encryptionInTransit.map(value => value.asEditable)
      )
    def encryptionAtRest
        : Optional[zio.aws.kafka.model.EncryptionAtRest.ReadOnly]
    def encryptionInTransit
        : Optional[zio.aws.kafka.model.EncryptionInTransit.ReadOnly]
    def getEncryptionAtRest
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionAtRest.ReadOnly] =
      AwsError.unwrapOptionField("encryptionAtRest", encryptionAtRest)
    def getEncryptionInTransit
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInTransit.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInTransit", encryptionInTransit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionInfo
  ) extends zio.aws.kafka.model.EncryptionInfo.ReadOnly {
    override val encryptionAtRest
        : Optional[zio.aws.kafka.model.EncryptionAtRest.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionAtRest())
        .map(value => zio.aws.kafka.model.EncryptionAtRest.wrap(value))
    override val encryptionInTransit
        : Optional[zio.aws.kafka.model.EncryptionInTransit.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionInTransit())
        .map(value => zio.aws.kafka.model.EncryptionInTransit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.EncryptionInfo
  ): zio.aws.kafka.model.EncryptionInfo.ReadOnly = new Wrapper(impl)
}
