package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListClusterOperationsRequest(
    clusterArn: __string,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest = {
    import ListClusterOperationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClusterOperationsRequest.ReadOnly =
    zio.aws.kafka.model.ListClusterOperationsRequest.wrap(buildAwsValue())
}
object ListClusterOperationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClusterOperationsRequest =
      zio.aws.kafka.model.ListClusterOperationsRequest(
        clusterArn,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterArn: __string
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[__string]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest
  ) extends zio.aws.kafka.model.ListClusterOperationsRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClusterOperationsRequest
  ): zio.aws.kafka.model.ListClusterOperationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
