package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListKafkaVersionsResponse(
    kafkaVersions: Optional[Iterable[zio.aws.kafka.model.KafkaVersion]] =
      Optional.Absent,
    nextToken: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse = {
    import ListKafkaVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse
      .builder()
      .optionallyWith(
        kafkaVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.kafkaVersions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly =
    zio.aws.kafka.model.ListKafkaVersionsResponse.wrap(buildAwsValue())
}
object ListKafkaVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListKafkaVersionsResponse =
      zio.aws.kafka.model.ListKafkaVersionsResponse(
        kafkaVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def kafkaVersions: Optional[List[zio.aws.kafka.model.KafkaVersion.ReadOnly]]
    def nextToken: Optional[__string]
    def getKafkaVersions
        : ZIO[Any, AwsError, List[zio.aws.kafka.model.KafkaVersion.ReadOnly]] =
      AwsError.unwrapOptionField("kafkaVersions", kafkaVersions)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse
  ) extends zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly {
    override val kafkaVersions
        : Optional[List[zio.aws.kafka.model.KafkaVersion.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kafkaVersions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kafka.model.KafkaVersion.wrap(item)
          }.toList
        )
    override val nextToken: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListKafkaVersionsResponse
  ): zio.aws.kafka.model.ListKafkaVersionsResponse.ReadOnly = new Wrapper(impl)
}
