package zio.aws.kafka.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.kafka.model.primitives.{__string, __integerMin1Max15}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Provisioned(
    brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo,
    currentBrokerSoftwareInfo: Optional[
      zio.aws.kafka.model.BrokerSoftwareInfo
    ] = Optional.Absent,
    clientAuthentication: Optional[zio.aws.kafka.model.ClientAuthentication] =
      Optional.Absent,
    encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo] =
      Optional.Absent,
    enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      Optional.Absent,
    openMonitoring: Optional[zio.aws.kafka.model.OpenMonitoringInfo] =
      Optional.Absent,
    loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo] = Optional.Absent,
    numberOfBrokerNodes: __integerMin1Max15,
    zookeeperConnectString: Optional[__string] = Optional.Absent,
    zookeeperConnectStringTls: Optional[__string] = Optional.Absent,
    storageMode: Optional[zio.aws.kafka.model.StorageMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.Provisioned = {
    import Provisioned.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Provisioned
      .builder()
      .brokerNodeGroupInfo(brokerNodeGroupInfo.buildAwsValue())
      .optionallyWith(
        currentBrokerSoftwareInfo.map(value => value.buildAwsValue())
      )(_.currentBrokerSoftwareInfo)
      .optionallyWith(clientAuthentication.map(value => value.buildAwsValue()))(
        _.clientAuthentication
      )
      .optionallyWith(encryptionInfo.map(value => value.buildAwsValue()))(
        _.encryptionInfo
      )
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .numberOfBrokerNodes(numberOfBrokerNodes: Integer)
      .optionallyWith(
        zookeeperConnectString.map(value => value: java.lang.String)
      )(_.zookeeperConnectString)
      .optionallyWith(
        zookeeperConnectStringTls.map(value => value: java.lang.String)
      )(_.zookeeperConnectStringTls)
      .optionallyWith(storageMode.map(value => value.unwrap))(_.storageMode)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Provisioned.ReadOnly =
    zio.aws.kafka.model.Provisioned.wrap(buildAwsValue())
}
object Provisioned {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Provisioned] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Provisioned =
      zio.aws.kafka.model.Provisioned(
        brokerNodeGroupInfo.asEditable,
        currentBrokerSoftwareInfo.map(value => value.asEditable),
        clientAuthentication.map(value => value.asEditable),
        encryptionInfo.map(value => value.asEditable),
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        loggingInfo.map(value => value.asEditable),
        numberOfBrokerNodes,
        zookeeperConnectString.map(value => value),
        zookeeperConnectStringTls.map(value => value),
        storageMode.map(value => value)
      )
    def brokerNodeGroupInfo: zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly
    def currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly]
    def clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly]
    def encryptionInfo: Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly]
    def enhancedMonitoring: Optional[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring
        : Optional[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly]
    def loggingInfo: Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def numberOfBrokerNodes: __integerMin1Max15
    def zookeeperConnectString: Optional[__string]
    def zookeeperConnectStringTls: Optional[__string]
    def storageMode: Optional[zio.aws.kafka.model.StorageMode]
    def getBrokerNodeGroupInfo
        : ZIO[Any, Nothing, zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly] =
      ZIO.succeed(brokerNodeGroupInfo)
    def getCurrentBrokerSoftwareInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentBrokerSoftwareInfo",
        currentBrokerSoftwareInfo
      )
    def getClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafka.model.ClientAuthentication.ReadOnly
    ] = AwsError.unwrapOptionField("clientAuthentication", clientAuthentication)
    def getEncryptionInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      AwsError.unwrapOptionField("encryptionInfo", encryptionInfo)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getNumberOfBrokerNodes: ZIO[Any, Nothing, __integerMin1Max15] =
      ZIO.succeed(numberOfBrokerNodes)
    def getZookeeperConnectString: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectString", zookeeperConnectString)
    def getZookeeperConnectStringTls: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("zookeeperConnectStringTls", zookeeperConnectStringTls)
    def getStorageMode: ZIO[Any, AwsError, zio.aws.kafka.model.StorageMode] =
      AwsError.unwrapOptionField("storageMode", storageMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Provisioned
  ) extends zio.aws.kafka.model.Provisioned.ReadOnly {
    override val brokerNodeGroupInfo
        : zio.aws.kafka.model.BrokerNodeGroupInfo.ReadOnly =
      zio.aws.kafka.model.BrokerNodeGroupInfo.wrap(impl.brokerNodeGroupInfo())
    override val currentBrokerSoftwareInfo
        : Optional[zio.aws.kafka.model.BrokerSoftwareInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentBrokerSoftwareInfo())
        .map(value => zio.aws.kafka.model.BrokerSoftwareInfo.wrap(value))
    override val clientAuthentication
        : Optional[zio.aws.kafka.model.ClientAuthentication.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientAuthentication())
        .map(value => zio.aws.kafka.model.ClientAuthentication.wrap(value))
    override val encryptionInfo
        : Optional[zio.aws.kafka.model.EncryptionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionInfo())
        .map(value => zio.aws.kafka.model.EncryptionInfo.wrap(value))
    override val enhancedMonitoring
        : Optional[zio.aws.kafka.model.EnhancedMonitoring] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enhancedMonitoring())
        .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Optional[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.openMonitoring())
        .map(value => zio.aws.kafka.model.OpenMonitoringInfo.wrap(value))
    override val loggingInfo
        : Optional[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
    override val numberOfBrokerNodes: __integerMin1Max15 =
      impl.numberOfBrokerNodes(): __integerMin1Max15
    override val zookeeperConnectString: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zookeeperConnectString())
        .map(value => value: __string)
    override val zookeeperConnectStringTls: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.zookeeperConnectStringTls())
        .map(value => value: __string)
    override val storageMode: Optional[zio.aws.kafka.model.StorageMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageMode())
        .map(value => zio.aws.kafka.model.StorageMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Provisioned
  ): zio.aws.kafka.model.Provisioned.ReadOnly = new Wrapper(impl)
}
