package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__boolean
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Scram(enabled: Optional[__boolean] = Optional.Absent) {
  def buildAwsValue(): software.amazon.awssdk.services.kafka.model.Scram = {
    import Scram.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.Scram
      .builder()
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.Scram.ReadOnly =
    zio.aws.kafka.model.Scram.wrap(buildAwsValue())
}
object Scram {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kafka.model.Scram] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.Scram =
      zio.aws.kafka.model.Scram(enabled.map(value => value))
    def enabled: Optional[__boolean]
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.Scram
  ) extends zio.aws.kafka.model.Scram.ReadOnly {
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.Scram
  ): zio.aws.kafka.model.Scram.ReadOnly = new Wrapper(impl)
}
