package zio.aws.kafka.model
import scala.jdk.CollectionConverters._
sealed trait StorageMode {
  def unwrap: software.amazon.awssdk.services.kafka.model.StorageMode
}
object StorageMode {
  def wrap(
      value: software.amazon.awssdk.services.kafka.model.StorageMode
  ): zio.aws.kafka.model.StorageMode = value match {
    case software.amazon.awssdk.services.kafka.model.StorageMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kafka.model.StorageMode.LOCAL =>
      val r = LOCAL
      r
    case software.amazon.awssdk.services.kafka.model.StorageMode.TIERED =>
      val r = TIERED
      r
  }
  case object unknownToSdkVersion extends zio.aws.kafka.model.StorageMode {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.StorageMode =
      software.amazon.awssdk.services.kafka.model.StorageMode.UNKNOWN_TO_SDK_VERSION
  }
  case object LOCAL extends zio.aws.kafka.model.StorageMode {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.StorageMode =
      software.amazon.awssdk.services.kafka.model.StorageMode.LOCAL
  }
  case object TIERED extends zio.aws.kafka.model.StorageMode {
    override def unwrap
        : software.amazon.awssdk.services.kafka.model.StorageMode =
      software.amazon.awssdk.services.kafka.model.StorageMode.TIERED
  }
}
