package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateBrokerTypeResponse(
    clusterArn: Optional[__string] = Optional.Absent,
    clusterOperationArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse = {
    import UpdateBrokerTypeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
      .builder()
      .optionallyWith(clusterArn.map(value => value: java.lang.String))(
        _.clusterArn
      )
      .optionallyWith(
        clusterOperationArn.map(value => value: java.lang.String)
      )(_.clusterOperationArn)
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly =
    zio.aws.kafka.model.UpdateBrokerTypeResponse.wrap(buildAwsValue())
}
object UpdateBrokerTypeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateBrokerTypeResponse =
      zio.aws.kafka.model.UpdateBrokerTypeResponse(
        clusterArn.map(value => value),
        clusterOperationArn.map(value => value)
      )
    def clusterArn: Optional[__string]
    def clusterOperationArn: Optional[__string]
    def getClusterArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterArn", clusterArn)
    def getClusterOperationArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterOperationArn", clusterOperationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ) extends zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly {
    override val clusterArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterArn())
      .map(value => value: __string)
    override val clusterOperationArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.clusterOperationArn())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateBrokerTypeResponse
  ): zio.aws.kafka.model.UpdateBrokerTypeResponse.ReadOnly = new Wrapper(impl)
}
