package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ClientAuthentication(
    sasl: Option[zio.aws.kafka.model.Sasl] = None,
    tls: Option[zio.aws.kafka.model.Tls] = None,
    unauthenticated: Option[zio.aws.kafka.model.Unauthenticated] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ClientAuthentication = {
    import ClientAuthentication.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ClientAuthentication
      .builder()
      .optionallyWith(sasl.map(value => value.buildAwsValue()))(_.sasl)
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .optionallyWith(unauthenticated.map(value => value.buildAwsValue()))(
        _.unauthenticated
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ClientAuthentication.ReadOnly =
    zio.aws.kafka.model.ClientAuthentication.wrap(buildAwsValue())
}
object ClientAuthentication {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ClientAuthentication =
      zio.aws.kafka.model.ClientAuthentication(
        sasl.map(value => value.asEditable),
        tls.map(value => value.asEditable),
        unauthenticated.map(value => value.asEditable)
      )
    def sasl: Option[zio.aws.kafka.model.Sasl.ReadOnly]
    def tls: Option[zio.aws.kafka.model.Tls.ReadOnly]
    def unauthenticated: Option[zio.aws.kafka.model.Unauthenticated.ReadOnly]
    def getSasl: ZIO[Any, AwsError, zio.aws.kafka.model.Sasl.ReadOnly] =
      AwsError.unwrapOptionField("sasl", sasl)
    def getTls: ZIO[Any, AwsError, zio.aws.kafka.model.Tls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
    def getUnauthenticated
        : ZIO[Any, AwsError, zio.aws.kafka.model.Unauthenticated.ReadOnly] =
      AwsError.unwrapOptionField("unauthenticated", unauthenticated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ) extends zio.aws.kafka.model.ClientAuthentication.ReadOnly {
    override val sasl: Option[zio.aws.kafka.model.Sasl.ReadOnly] = scala
      .Option(impl.sasl())
      .map(value => zio.aws.kafka.model.Sasl.wrap(value))
    override val tls: Option[zio.aws.kafka.model.Tls.ReadOnly] =
      scala.Option(impl.tls()).map(value => zio.aws.kafka.model.Tls.wrap(value))
    override val unauthenticated
        : Option[zio.aws.kafka.model.Unauthenticated.ReadOnly] = scala
      .Option(impl.unauthenticated())
      .map(value => zio.aws.kafka.model.Unauthenticated.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ClientAuthentication
  ): zio.aws.kafka.model.ClientAuthentication.ReadOnly = new Wrapper(impl)
}
