package zio.aws.kafka.model
import java.lang.Integer
import zio.ZIO
import zio.aws.kafka.model.primitives.{MaxResults, __string}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListClustersRequest(
    clusterNameFilter: Option[__string] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[__string] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.ListClustersRequest = {
    import ListClustersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.ListClustersRequest
      .builder()
      .optionallyWith(clusterNameFilter.map(value => value: java.lang.String))(
        _.clusterNameFilter
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.ListClustersRequest.ReadOnly =
    zio.aws.kafka.model.ListClustersRequest.wrap(buildAwsValue())
}
object ListClustersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.ListClustersRequest =
      zio.aws.kafka.model.ListClustersRequest(
        clusterNameFilter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def clusterNameFilter: Option[__string]
    def maxResults: Option[MaxResults]
    def nextToken: Option[__string]
    def getClusterNameFilter: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("clusterNameFilter", clusterNameFilter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ) extends zio.aws.kafka.model.ListClustersRequest.ReadOnly {
    override val clusterNameFilter: Option[__string] =
      scala.Option(impl.clusterNameFilter()).map(value => value: __string)
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.kafka.model.primitives.MaxResults(value))
    override val nextToken: Option[__string] =
      scala.Option(impl.nextToken()).map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.ListClustersRequest
  ): zio.aws.kafka.model.ListClustersRequest.ReadOnly = new Wrapper(impl)
}
