package zio.aws.kafka.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OpenMonitoring(prometheus: zio.aws.kafka.model.Prometheus) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.OpenMonitoring = {
    import OpenMonitoring.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.OpenMonitoring
      .builder()
      .prometheus(prometheus.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.OpenMonitoring.ReadOnly =
    zio.aws.kafka.model.OpenMonitoring.wrap(buildAwsValue())
}
object OpenMonitoring {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.OpenMonitoring
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.OpenMonitoring =
      zio.aws.kafka.model.OpenMonitoring(prometheus.asEditable)
    def prometheus: zio.aws.kafka.model.Prometheus.ReadOnly
    def getPrometheus
        : ZIO[Any, Nothing, zio.aws.kafka.model.Prometheus.ReadOnly] =
      ZIO.succeed(prometheus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.OpenMonitoring
  ) extends zio.aws.kafka.model.OpenMonitoring.ReadOnly {
    override val prometheus: zio.aws.kafka.model.Prometheus.ReadOnly =
      zio.aws.kafka.model.Prometheus.wrap(impl.prometheus())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.OpenMonitoring
  ): zio.aws.kafka.model.OpenMonitoring.ReadOnly = new Wrapper(impl)
}
