package zio.aws.kafka.model
import zio.ZIO
import zio.aws.kafka.model.primitives.__string
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class UpdateMonitoringRequest(
    clusterArn: __string,
    currentVersion: __string,
    enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring] = None,
    openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo] = None,
    loggingInfo: Option[zio.aws.kafka.model.LoggingInfo] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest = {
    import UpdateMonitoringRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest
      .builder()
      .clusterArn(clusterArn: java.lang.String)
      .currentVersion(currentVersion: java.lang.String)
      .optionallyWith(enhancedMonitoring.map(value => value.unwrap))(
        _.enhancedMonitoring
      )
      .optionallyWith(openMonitoring.map(value => value.buildAwsValue()))(
        _.openMonitoring
      )
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .build()
  }
  def asReadOnly: zio.aws.kafka.model.UpdateMonitoringRequest.ReadOnly =
    zio.aws.kafka.model.UpdateMonitoringRequest.wrap(buildAwsValue())
}
object UpdateMonitoringRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafka.model.UpdateMonitoringRequest =
      zio.aws.kafka.model.UpdateMonitoringRequest(
        clusterArn,
        currentVersion,
        enhancedMonitoring.map(value => value),
        openMonitoring.map(value => value.asEditable),
        loggingInfo.map(value => value.asEditable)
      )
    def clusterArn: __string
    def currentVersion: __string
    def enhancedMonitoring: Option[zio.aws.kafka.model.EnhancedMonitoring]
    def openMonitoring: Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly]
    def loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly]
    def getClusterArn: ZIO[Any, Nothing, __string] = ZIO.succeed(clusterArn)
    def getCurrentVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(currentVersion)
    def getEnhancedMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.EnhancedMonitoring] =
      AwsError.unwrapOptionField("enhancedMonitoring", enhancedMonitoring)
    def getOpenMonitoring
        : ZIO[Any, AwsError, zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] =
      AwsError.unwrapOptionField("openMonitoring", openMonitoring)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest
  ) extends zio.aws.kafka.model.UpdateMonitoringRequest.ReadOnly {
    override val clusterArn: __string = impl.clusterArn(): __string
    override val currentVersion: __string = impl.currentVersion(): __string
    override val enhancedMonitoring
        : Option[zio.aws.kafka.model.EnhancedMonitoring] = scala
      .Option(impl.enhancedMonitoring())
      .map(value => zio.aws.kafka.model.EnhancedMonitoring.wrap(value))
    override val openMonitoring
        : Option[zio.aws.kafka.model.OpenMonitoringInfo.ReadOnly] = scala
      .Option(impl.openMonitoring())
      .map(value => zio.aws.kafka.model.OpenMonitoringInfo.wrap(value))
    override val loggingInfo: Option[zio.aws.kafka.model.LoggingInfo.ReadOnly] =
      scala
        .Option(impl.loggingInfo())
        .map(value => zio.aws.kafka.model.LoggingInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafka.model.UpdateMonitoringRequest
  ): zio.aws.kafka.model.UpdateMonitoringRequest.ReadOnly = new Wrapper(impl)
}
