package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class ApacheKafkaClusterDescription(
    bootstrapServers: Optional[__string] = Optional.Absent,
    vpc: Optional[zio.aws.kafkaconnect.model.VpcDescription] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaClusterDescription = {
    import ApacheKafkaClusterDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaClusterDescription
      .builder()
      .optionallyWith(bootstrapServers.map(value => value: java.lang.String))(
        _.bootstrapServers
      )
      .optionallyWith(vpc.map(value => value.buildAwsValue()))(_.vpc)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly =
    zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription
      .wrap(buildAwsValue())
}
object ApacheKafkaClusterDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaClusterDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription =
      zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription(
        bootstrapServers.map(value => value),
        vpc.map(value => value.asEditable)
      )
    def bootstrapServers: Optional[__string]
    def vpc: Optional[zio.aws.kafkaconnect.model.VpcDescription.ReadOnly]
    def getBootstrapServers: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("bootstrapServers", bootstrapServers)
    def getVpc: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.VpcDescription.ReadOnly
    ] = AwsError.unwrapOptionField("vpc", vpc)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaClusterDescription
  ) extends zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly {
    override val bootstrapServers: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.bootstrapServers())
      .map(value => value: __string)
    override val vpc
        : Optional[zio.aws.kafkaconnect.model.VpcDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpc())
        .map(value => zio.aws.kafkaconnect.model.VpcDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.ApacheKafkaClusterDescription
  ): zio.aws.kafkaconnect.model.ApacheKafkaClusterDescription.ReadOnly =
    new Wrapper(impl)
}
