package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.__integer
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutoScalingDescription(
    maxWorkerCount: Optional[__integer] = Optional.Absent,
    mcuCount: Optional[__integer] = Optional.Absent,
    minWorkerCount: Optional[__integer] = Optional.Absent,
    scaleInPolicy: Optional[
      zio.aws.kafkaconnect.model.ScaleInPolicyDescription
    ] = Optional.Absent,
    scaleOutPolicy: Optional[
      zio.aws.kafkaconnect.model.ScaleOutPolicyDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.AutoScalingDescription = {
    import AutoScalingDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.AutoScalingDescription
      .builder()
      .optionallyWith(maxWorkerCount.map(value => value: Integer))(
        _.maxWorkerCount
      )
      .optionallyWith(mcuCount.map(value => value: Integer))(_.mcuCount)
      .optionallyWith(minWorkerCount.map(value => value: Integer))(
        _.minWorkerCount
      )
      .optionallyWith(scaleInPolicy.map(value => value.buildAwsValue()))(
        _.scaleInPolicy
      )
      .optionallyWith(scaleOutPolicy.map(value => value.buildAwsValue()))(
        _.scaleOutPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly =
    zio.aws.kafkaconnect.model.AutoScalingDescription.wrap(buildAwsValue())
}
object AutoScalingDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.AutoScalingDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.AutoScalingDescription =
      zio.aws.kafkaconnect.model.AutoScalingDescription(
        maxWorkerCount.map(value => value),
        mcuCount.map(value => value),
        minWorkerCount.map(value => value),
        scaleInPolicy.map(value => value.asEditable),
        scaleOutPolicy.map(value => value.asEditable)
      )
    def maxWorkerCount: Optional[__integer]
    def mcuCount: Optional[__integer]
    def minWorkerCount: Optional[__integer]
    def scaleInPolicy
        : Optional[zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly]
    def scaleOutPolicy: Optional[
      zio.aws.kafkaconnect.model.ScaleOutPolicyDescription.ReadOnly
    ]
    def getMaxWorkerCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("maxWorkerCount", maxWorkerCount)
    def getMcuCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("mcuCount", mcuCount)
    def getMinWorkerCount: ZIO[Any, AwsError, __integer] =
      AwsError.unwrapOptionField("minWorkerCount", minWorkerCount)
    def getScaleInPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField("scaleInPolicy", scaleInPolicy)
    def getScaleOutPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ScaleOutPolicyDescription.ReadOnly
    ] = AwsError.unwrapOptionField("scaleOutPolicy", scaleOutPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScalingDescription
  ) extends zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly {
    override val maxWorkerCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxWorkerCount())
      .map(value => value: __integer)
    override val mcuCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.mcuCount())
      .map(value => value: __integer)
    override val minWorkerCount: Optional[__integer] = zio.aws.core.internal
      .optionalFromNullable(impl.minWorkerCount())
      .map(value => value: __integer)
    override val scaleInPolicy: Optional[
      zio.aws.kafkaconnect.model.ScaleInPolicyDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleInPolicy())
      .map(value =>
        zio.aws.kafkaconnect.model.ScaleInPolicyDescription.wrap(value)
      )
    override val scaleOutPolicy: Optional[
      zio.aws.kafkaconnect.model.ScaleOutPolicyDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.scaleOutPolicy())
      .map(value =>
        zio.aws.kafkaconnect.model.ScaleOutPolicyDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScalingDescription
  ): zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly = new Wrapper(
    impl
  )
}
