package zio.aws.kafkaconnect.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.kafkaconnect.model.primitives.{
  __integerMin1Max8,
  __integerMin1Max10
}
import scala.jdk.CollectionConverters.*
final case class AutoScalingUpdate(
    maxWorkerCount: __integerMin1Max10,
    mcuCount: __integerMin1Max8,
    minWorkerCount: __integerMin1Max10,
    scaleInPolicy: zio.aws.kafkaconnect.model.ScaleInPolicyUpdate,
    scaleOutPolicy: zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate = {
    import AutoScalingUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate
      .builder()
      .maxWorkerCount(maxWorkerCount: Integer)
      .mcuCount(mcuCount: Integer)
      .minWorkerCount(minWorkerCount: Integer)
      .scaleInPolicy(scaleInPolicy.buildAwsValue())
      .scaleOutPolicy(scaleOutPolicy.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly =
    zio.aws.kafkaconnect.model.AutoScalingUpdate.wrap(buildAwsValue())
}
object AutoScalingUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.AutoScalingUpdate =
      zio.aws.kafkaconnect.model.AutoScalingUpdate(
        maxWorkerCount,
        mcuCount,
        minWorkerCount,
        scaleInPolicy.asEditable,
        scaleOutPolicy.asEditable
      )
    def maxWorkerCount: __integerMin1Max10
    def mcuCount: __integerMin1Max8
    def minWorkerCount: __integerMin1Max10
    def scaleInPolicy: zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly
    def scaleOutPolicy: zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly
    def getMaxWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(maxWorkerCount)
    def getMcuCount: ZIO[Any, Nothing, __integerMin1Max8] =
      ZIO.succeed(mcuCount)
    def getMinWorkerCount: ZIO[Any, Nothing, __integerMin1Max10] =
      ZIO.succeed(minWorkerCount)
    def getScaleInPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly
    ] = ZIO.succeed(scaleInPolicy)
    def getScaleOutPolicy: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly
    ] = ZIO.succeed(scaleOutPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate
  ) extends zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly {
    override val maxWorkerCount: __integerMin1Max10 =
      impl.maxWorkerCount(): __integerMin1Max10
    override val mcuCount: __integerMin1Max8 =
      impl.mcuCount(): __integerMin1Max8
    override val minWorkerCount: __integerMin1Max10 =
      impl.minWorkerCount(): __integerMin1Max10
    override val scaleInPolicy
        : zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.ReadOnly =
      zio.aws.kafkaconnect.model.ScaleInPolicyUpdate.wrap(impl.scaleInPolicy())
    override val scaleOutPolicy
        : zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate.ReadOnly =
      zio.aws.kafkaconnect.model.ScaleOutPolicyUpdate
        .wrap(impl.scaleOutPolicy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.AutoScalingUpdate
  ): zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly = new Wrapper(impl)
}
