package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CapacityDescription(
    autoScaling: Optional[zio.aws.kafkaconnect.model.AutoScalingDescription] =
      Optional.Absent,
    provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription = {
    import CapacityDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription
      .builder()
      .optionallyWith(autoScaling.map(value => value.buildAwsValue()))(
        _.autoScaling
      )
      .optionallyWith(provisionedCapacity.map(value => value.buildAwsValue()))(
        _.provisionedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly =
    zio.aws.kafkaconnect.model.CapacityDescription.wrap(buildAwsValue())
}
object CapacityDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CapacityDescription =
      zio.aws.kafkaconnect.model.CapacityDescription(
        autoScaling.map(value => value.asEditable),
        provisionedCapacity.map(value => value.asEditable)
      )
    def autoScaling
        : Optional[zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly]
    def provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly
    ]
    def getAutoScaling: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly
    ] = AwsError.unwrapOptionField("autoScaling", autoScaling)
    def getProvisionedCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly
    ] = AwsError.unwrapOptionField("provisionedCapacity", provisionedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription
  ) extends zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly {
    override val autoScaling
        : Optional[zio.aws.kafkaconnect.model.AutoScalingDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScaling())
        .map(value =>
          zio.aws.kafkaconnect.model.AutoScalingDescription.wrap(value)
        )
    override val provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedCapacity())
      .map(value =>
        zio.aws.kafkaconnect.model.ProvisionedCapacityDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CapacityDescription
  ): zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly = new Wrapper(impl)
}
