package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CapacityUpdate(
    autoScaling: Optional[zio.aws.kafkaconnect.model.AutoScalingUpdate] =
      Optional.Absent,
    provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CapacityUpdate = {
    import CapacityUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CapacityUpdate
      .builder()
      .optionallyWith(autoScaling.map(value => value.buildAwsValue()))(
        _.autoScaling
      )
      .optionallyWith(provisionedCapacity.map(value => value.buildAwsValue()))(
        _.provisionedCapacity
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly =
    zio.aws.kafkaconnect.model.CapacityUpdate.wrap(buildAwsValue())
}
object CapacityUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CapacityUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CapacityUpdate =
      zio.aws.kafkaconnect.model.CapacityUpdate(
        autoScaling.map(value => value.asEditable),
        provisionedCapacity.map(value => value.asEditable)
      )
    def autoScaling
        : Optional[zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly]
    def provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly
    ]
    def getAutoScaling: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("autoScaling", autoScaling)
    def getProvisionedCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly
    ] = AwsError.unwrapOptionField("provisionedCapacity", provisionedCapacity)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CapacityUpdate
  ) extends zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly {
    override val autoScaling
        : Optional[zio.aws.kafkaconnect.model.AutoScalingUpdate.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoScaling())
        .map(value => zio.aws.kafkaconnect.model.AutoScalingUpdate.wrap(value))
    override val provisionedCapacity: Optional[
      zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.provisionedCapacity())
      .map(value =>
        zio.aws.kafkaconnect.model.ProvisionedCapacityUpdate.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CapacityUpdate
  ): zio.aws.kafkaconnect.model.CapacityUpdate.ReadOnly = new Wrapper(impl)
}
