package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__string, __boolean}
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsLogDelivery(
    enabled: __boolean,
    logGroup: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery = {
    import CloudWatchLogsLogDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery
      .builder()
      .enabled(enabled: java.lang.Boolean)
      .optionallyWith(logGroup.map(value => value: java.lang.String))(
        _.logGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly =
    zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.wrap(buildAwsValue())
}
object CloudWatchLogsLogDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery =
      zio.aws.kafkaconnect.model
        .CloudWatchLogsLogDelivery(enabled, logGroup.map(value => value))
    def enabled: __boolean
    def logGroup: Optional[__string]
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
    def getLogGroup: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("logGroup", logGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery
  ) extends zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly {
    override val enabled: __boolean = impl.enabled(): __boolean
    override val logGroup: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.logGroup())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CloudWatchLogsLogDelivery
  ): zio.aws.kafkaconnect.model.CloudWatchLogsLogDelivery.ReadOnly =
    new Wrapper(impl)
}
