package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{
  __stringMin1Max128,
  __stringMax1024,
  __string
}
import scala.jdk.CollectionConverters.*
final case class CreateConnectorRequest(
    capacity: zio.aws.kafkaconnect.model.Capacity,
    connectorConfiguration: Map[__string, __string],
    connectorDescription: Optional[__stringMax1024] = Optional.Absent,
    connectorName: __stringMin1Max128,
    kafkaCluster: zio.aws.kafkaconnect.model.KafkaCluster,
    kafkaClusterClientAuthentication: zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication,
    kafkaClusterEncryptionInTransit: zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit,
    kafkaConnectVersion: __string,
    logDelivery: Optional[zio.aws.kafkaconnect.model.LogDelivery] =
      Optional.Absent,
    plugins: Iterable[zio.aws.kafkaconnect.model.Plugin],
    serviceExecutionRoleArn: __string,
    workerConfiguration: Optional[
      zio.aws.kafkaconnect.model.WorkerConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest = {
    import CreateConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest
      .builder()
      .capacity(capacity.buildAwsValue())
      .connectorConfiguration(
        connectorConfiguration
          .map({ case (key, value) =>
            (key: java.lang.String) -> (value: java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        connectorDescription.map(value => value: java.lang.String)
      )(_.connectorDescription)
      .connectorName(connectorName: java.lang.String)
      .kafkaCluster(kafkaCluster.buildAwsValue())
      .kafkaClusterClientAuthentication(
        kafkaClusterClientAuthentication.buildAwsValue()
      )
      .kafkaClusterEncryptionInTransit(
        kafkaClusterEncryptionInTransit.buildAwsValue()
      )
      .kafkaConnectVersion(kafkaConnectVersion: java.lang.String)
      .optionallyWith(logDelivery.map(value => value.buildAwsValue()))(
        _.logDelivery
      )
      .plugins(plugins.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .serviceExecutionRoleArn(serviceExecutionRoleArn: java.lang.String)
      .optionallyWith(workerConfiguration.map(value => value.buildAwsValue()))(
        _.workerConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CreateConnectorRequest.ReadOnly =
    zio.aws.kafkaconnect.model.CreateConnectorRequest.wrap(buildAwsValue())
}
object CreateConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CreateConnectorRequest =
      zio.aws.kafkaconnect.model.CreateConnectorRequest(
        capacity.asEditable,
        connectorConfiguration,
        connectorDescription.map(value => value),
        connectorName,
        kafkaCluster.asEditable,
        kafkaClusterClientAuthentication.asEditable,
        kafkaClusterEncryptionInTransit.asEditable,
        kafkaConnectVersion,
        logDelivery.map(value => value.asEditable),
        plugins.map { item =>
          item.asEditable
        },
        serviceExecutionRoleArn,
        workerConfiguration.map(value => value.asEditable)
      )
    def capacity: zio.aws.kafkaconnect.model.Capacity.ReadOnly
    def connectorConfiguration: Map[__string, __string]
    def connectorDescription: Optional[__stringMax1024]
    def connectorName: __stringMin1Max128
    def kafkaCluster: zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly
    def kafkaClusterClientAuthentication
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly
    def kafkaClusterEncryptionInTransit
        : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly
    def kafkaConnectVersion: __string
    def logDelivery: Optional[zio.aws.kafkaconnect.model.LogDelivery.ReadOnly]
    def plugins: List[zio.aws.kafkaconnect.model.Plugin.ReadOnly]
    def serviceExecutionRoleArn: __string
    def workerConfiguration
        : Optional[zio.aws.kafkaconnect.model.WorkerConfiguration.ReadOnly]
    def getCapacity
        : ZIO[Any, Nothing, zio.aws.kafkaconnect.model.Capacity.ReadOnly] =
      ZIO.succeed(capacity)
    def getConnectorConfiguration: ZIO[Any, Nothing, Map[__string, __string]] =
      ZIO.succeed(connectorConfiguration)
    def getConnectorDescription: ZIO[Any, AwsError, __stringMax1024] =
      AwsError.unwrapOptionField("connectorDescription", connectorDescription)
    def getConnectorName: ZIO[Any, Nothing, __stringMin1Max128] =
      ZIO.succeed(connectorName)
    def getKafkaCluster
        : ZIO[Any, Nothing, zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly] =
      ZIO.succeed(kafkaCluster)
    def getKafkaClusterClientAuthentication: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly
    ] = ZIO.succeed(kafkaClusterClientAuthentication)
    def getKafkaClusterEncryptionInTransit: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly
    ] = ZIO.succeed(kafkaClusterEncryptionInTransit)
    def getKafkaConnectVersion: ZIO[Any, Nothing, __string] =
      ZIO.succeed(kafkaConnectVersion)
    def getLogDelivery
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.LogDelivery.ReadOnly] =
      AwsError.unwrapOptionField("logDelivery", logDelivery)
    def getPlugins
        : ZIO[Any, Nothing, List[zio.aws.kafkaconnect.model.Plugin.ReadOnly]] =
      ZIO.succeed(plugins)
    def getServiceExecutionRoleArn: ZIO[Any, Nothing, __string] =
      ZIO.succeed(serviceExecutionRoleArn)
    def getWorkerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("workerConfiguration", workerConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest
  ) extends zio.aws.kafkaconnect.model.CreateConnectorRequest.ReadOnly {
    override val capacity: zio.aws.kafkaconnect.model.Capacity.ReadOnly =
      zio.aws.kafkaconnect.model.Capacity.wrap(impl.capacity())
    override val connectorConfiguration: Map[__string, __string] = impl
      .connectorConfiguration()
      .asScala
      .map({ case (key, value) =>
        (key: __string) -> (value: __string)
      })
      .toMap
    override val connectorDescription: Optional[__stringMax1024] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorDescription())
        .map(value => value: __stringMax1024)
    override val connectorName: __stringMin1Max128 =
      impl.connectorName(): __stringMin1Max128
    override val kafkaCluster
        : zio.aws.kafkaconnect.model.KafkaCluster.ReadOnly =
      zio.aws.kafkaconnect.model.KafkaCluster.wrap(impl.kafkaCluster())
    override val kafkaClusterClientAuthentication
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication.ReadOnly =
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthentication
        .wrap(impl.kafkaClusterClientAuthentication())
    override val kafkaClusterEncryptionInTransit
        : zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit.ReadOnly =
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransit
        .wrap(impl.kafkaClusterEncryptionInTransit())
    override val kafkaConnectVersion: __string =
      impl.kafkaConnectVersion(): __string
    override val logDelivery
        : Optional[zio.aws.kafkaconnect.model.LogDelivery.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logDelivery())
        .map(value => zio.aws.kafkaconnect.model.LogDelivery.wrap(value))
    override val plugins: List[zio.aws.kafkaconnect.model.Plugin.ReadOnly] =
      impl
        .plugins()
        .asScala
        .map { item =>
          zio.aws.kafkaconnect.model.Plugin.wrap(item)
        }
        .toList
    override val serviceExecutionRoleArn: __string =
      impl.serviceExecutionRoleArn(): __string
    override val workerConfiguration
        : Optional[zio.aws.kafkaconnect.model.WorkerConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerConfiguration())
        .map(value =>
          zio.aws.kafkaconnect.model.WorkerConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorRequest
  ): zio.aws.kafkaconnect.model.CreateConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
