package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class CreateConnectorResponse(
    connectorArn: Optional[__string] = Optional.Absent,
    connectorName: Optional[__string] = Optional.Absent,
    connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse = {
    import CreateConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse
      .builder()
      .optionallyWith(connectorArn.map(value => value: java.lang.String))(
        _.connectorArn
      )
      .optionallyWith(connectorName.map(value => value: java.lang.String))(
        _.connectorName
      )
      .optionallyWith(connectorState.map(value => value.unwrap))(
        _.connectorState
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly =
    zio.aws.kafkaconnect.model.CreateConnectorResponse.wrap(buildAwsValue())
}
object CreateConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CreateConnectorResponse =
      zio.aws.kafkaconnect.model.CreateConnectorResponse(
        connectorArn.map(value => value),
        connectorName.map(value => value),
        connectorState.map(value => value)
      )
    def connectorArn: Optional[__string]
    def connectorName: Optional[__string]
    def connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState]
    def getConnectorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
    def getConnectorName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorName", connectorName)
    def getConnectorState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.ConnectorState] =
      AwsError.unwrapOptionField("connectorState", connectorState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse
  ) extends zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly {
    override val connectorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => value: __string)
    override val connectorName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorName())
      .map(value => value: __string)
    override val connectorState
        : Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorState())
        .map(value => zio.aws.kafkaconnect.model.ConnectorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateConnectorResponse
  ): zio.aws.kafkaconnect.model.CreateConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
