package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{
  __stringMin1Max128,
  __stringMax1024
}
import scala.jdk.CollectionConverters.*
final case class CreateCustomPluginRequest(
    contentType: zio.aws.kafkaconnect.model.CustomPluginContentType,
    description: Optional[__stringMax1024] = Optional.Absent,
    location: zio.aws.kafkaconnect.model.CustomPluginLocation,
    name: __stringMin1Max128
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest = {
    import CreateCustomPluginRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest
      .builder()
      .contentType(contentType.unwrap)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .location(location.buildAwsValue())
      .name(name: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CreateCustomPluginRequest.ReadOnly =
    zio.aws.kafkaconnect.model.CreateCustomPluginRequest.wrap(buildAwsValue())
}
object CreateCustomPluginRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CreateCustomPluginRequest =
      zio.aws.kafkaconnect.model.CreateCustomPluginRequest(
        contentType,
        description.map(value => value),
        location.asEditable,
        name
      )
    def contentType: zio.aws.kafkaconnect.model.CustomPluginContentType
    def description: Optional[__stringMax1024]
    def location: zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly
    def name: __stringMin1Max128
    def getContentType: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.CustomPluginContentType
    ] = ZIO.succeed(contentType)
    def getDescription: ZIO[Any, AwsError, __stringMax1024] =
      AwsError.unwrapOptionField("description", description)
    def getLocation: ZIO[
      Any,
      Nothing,
      zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly
    ] = ZIO.succeed(location)
    def getName: ZIO[Any, Nothing, __stringMin1Max128] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest
  ) extends zio.aws.kafkaconnect.model.CreateCustomPluginRequest.ReadOnly {
    override val contentType
        : zio.aws.kafkaconnect.model.CustomPluginContentType =
      zio.aws.kafkaconnect.model.CustomPluginContentType
        .wrap(impl.contentType())
    override val description: Optional[__stringMax1024] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __stringMax1024)
    override val location
        : zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly =
      zio.aws.kafkaconnect.model.CustomPluginLocation.wrap(impl.location())
    override val name: __stringMin1Max128 = impl.name(): __stringMin1Max128
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateCustomPluginRequest
  ): zio.aws.kafkaconnect.model.CreateCustomPluginRequest.ReadOnly =
    new Wrapper(impl)
}
