package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{
  SyntheticCreateWorkerConfigurationRequest__string,
  __stringMin1Max128,
  __stringMax1024
}
import scala.jdk.CollectionConverters.*
final case class CreateWorkerConfigurationRequest(
    description: Optional[__stringMax1024] = Optional.Absent,
    name: __stringMin1Max128,
    propertiesFileContent: SyntheticCreateWorkerConfigurationRequest__string
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest = {
    import CreateWorkerConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest
      .builder()
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .name(name: java.lang.String)
      .propertiesFileContent(
        SyntheticCreateWorkerConfigurationRequest__string.unwrap(
          propertiesFileContent
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest.ReadOnly =
    zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateWorkerConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest =
      zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest(
        description.map(value => value),
        name,
        propertiesFileContent
      )
    def description: Optional[__stringMax1024]
    def name: __stringMin1Max128
    def propertiesFileContent: SyntheticCreateWorkerConfigurationRequest__string
    def getDescription: ZIO[Any, AwsError, __stringMax1024] =
      AwsError.unwrapOptionField("description", description)
    def getName: ZIO[Any, Nothing, __stringMin1Max128] = ZIO.succeed(name)
    def getPropertiesFileContent
        : ZIO[Any, Nothing, SyntheticCreateWorkerConfigurationRequest__string] =
      ZIO.succeed(propertiesFileContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest
  ) extends zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest.ReadOnly {
    override val description: Optional[__stringMax1024] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __stringMax1024)
    override val name: __stringMin1Max128 = impl.name(): __stringMin1Max128
    override val propertiesFileContent
        : SyntheticCreateWorkerConfigurationRequest__string =
      zio.aws.kafkaconnect.model.primitives
        .SyntheticCreateWorkerConfigurationRequest__string(
          impl.propertiesFileContent()
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CreateWorkerConfigurationRequest
  ): zio.aws.kafkaconnect.model.CreateWorkerConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
