package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__long, __string}
import scala.jdk.CollectionConverters.*
final case class CustomPluginDescription(
    customPluginArn: Optional[__string] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginDescription = {
    import CustomPluginDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginDescription
      .builder()
      .optionallyWith(customPluginArn.map(value => value: java.lang.String))(
        _.customPluginArn
      )
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly =
    zio.aws.kafkaconnect.model.CustomPluginDescription.wrap(buildAwsValue())
}
object CustomPluginDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CustomPluginDescription =
      zio.aws.kafkaconnect.model.CustomPluginDescription(
        customPluginArn.map(value => value),
        revision.map(value => value)
      )
    def customPluginArn: Optional[__string]
    def revision: Optional[__long]
    def getCustomPluginArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("customPluginArn", customPluginArn)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginDescription
  ) extends zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly {
    override val customPluginArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.customPluginArn())
      .map(value => value: __string)
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginDescription
  ): zio.aws.kafkaconnect.model.CustomPluginDescription.ReadOnly = new Wrapper(
    impl
  )
}
