package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CustomPluginLocation(
    s3Location: zio.aws.kafkaconnect.model.S3Location
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocation = {
    import CustomPluginLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocation
      .builder()
      .s3Location(s3Location.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly =
    zio.aws.kafkaconnect.model.CustomPluginLocation.wrap(buildAwsValue())
}
object CustomPluginLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CustomPluginLocation =
      zio.aws.kafkaconnect.model.CustomPluginLocation(s3Location.asEditable)
    def s3Location: zio.aws.kafkaconnect.model.S3Location.ReadOnly
    def getS3Location
        : ZIO[Any, Nothing, zio.aws.kafkaconnect.model.S3Location.ReadOnly] =
      ZIO.succeed(s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocation
  ) extends zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly {
    override val s3Location: zio.aws.kafkaconnect.model.S3Location.ReadOnly =
      zio.aws.kafkaconnect.model.S3Location.wrap(impl.s3Location())
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocation
  ): zio.aws.kafkaconnect.model.CustomPluginLocation.ReadOnly = new Wrapper(
    impl
  )
}
