package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CustomPluginLocationDescription(
    s3Location: Optional[zio.aws.kafkaconnect.model.S3LocationDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription = {
    import CustomPluginLocationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly =
    zio.aws.kafkaconnect.model.CustomPluginLocationDescription
      .wrap(buildAwsValue())
}
object CustomPluginLocationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CustomPluginLocationDescription =
      zio.aws.kafkaconnect.model.CustomPluginLocationDescription(
        s3Location.map(value => value.asEditable)
      )
    def s3Location
        : Optional[zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly]
    def getS3Location: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription
  ) extends zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly {
    override val s3Location
        : Optional[zio.aws.kafkaconnect.model.S3LocationDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value =>
          zio.aws.kafkaconnect.model.S3LocationDescription.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginLocationDescription
  ): zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly =
    new Wrapper(impl)
}
