package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{
  __long,
  __string,
  __timestampIso8601
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CustomPluginRevisionSummary(
    contentType: Optional[zio.aws.kafkaconnect.model.CustomPluginContentType] =
      Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    fileDescription: Optional[
      zio.aws.kafkaconnect.model.CustomPluginFileDescription
    ] = Optional.Absent,
    location: Optional[
      zio.aws.kafkaconnect.model.CustomPluginLocationDescription
    ] = Optional.Absent,
    revision: Optional[__long] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary = {
    import CustomPluginRevisionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary
      .builder()
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(fileDescription.map(value => value.buildAwsValue()))(
        _.fileDescription
      )
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(revision.map(value => value: java.lang.Long))(_.revision)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly =
    zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.wrap(buildAwsValue())
}
object CustomPluginRevisionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.CustomPluginRevisionSummary =
      zio.aws.kafkaconnect.model.CustomPluginRevisionSummary(
        contentType.map(value => value),
        creationTime.map(value => value),
        description.map(value => value),
        fileDescription.map(value => value.asEditable),
        location.map(value => value.asEditable),
        revision.map(value => value)
      )
    def contentType
        : Optional[zio.aws.kafkaconnect.model.CustomPluginContentType]
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def fileDescription: Optional[
      zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly
    ]
    def location: Optional[
      zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly
    ]
    def revision: Optional[__long]
    def getContentType: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CustomPluginContentType
    ] = AwsError.unwrapOptionField("contentType", contentType)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getFileDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly
    ] = AwsError.unwrapOptionField("fileDescription", fileDescription)
    def getLocation: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("location", location)
    def getRevision: ZIO[Any, AwsError, __long] =
      AwsError.unwrapOptionField("revision", revision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary
  ) extends zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly {
    override val contentType
        : Optional[zio.aws.kafkaconnect.model.CustomPluginContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contentType())
        .map(value =>
          zio.aws.kafkaconnect.model.CustomPluginContentType.wrap(value)
        )
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val fileDescription: Optional[
      zio.aws.kafkaconnect.model.CustomPluginFileDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.fileDescription())
      .map(value =>
        zio.aws.kafkaconnect.model.CustomPluginFileDescription.wrap(value)
      )
    override val location: Optional[
      zio.aws.kafkaconnect.model.CustomPluginLocationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value =>
        zio.aws.kafkaconnect.model.CustomPluginLocationDescription.wrap(value)
      )
    override val revision: Optional[__long] = zio.aws.core.internal
      .optionalFromNullable(impl.revision())
      .map(value => value: __long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.CustomPluginRevisionSummary
  ): zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly =
    new Wrapper(impl)
}
