package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteConnectorRequest(
    connectorArn: __string,
    currentVersion: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest = {
    import DeleteConnectorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest
      .builder()
      .connectorArn(connectorArn: java.lang.String)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.DeleteConnectorRequest.ReadOnly =
    zio.aws.kafkaconnect.model.DeleteConnectorRequest.wrap(buildAwsValue())
}
object DeleteConnectorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.DeleteConnectorRequest =
      zio.aws.kafkaconnect.model.DeleteConnectorRequest(
        connectorArn,
        currentVersion.map(value => value)
      )
    def connectorArn: __string
    def currentVersion: Optional[__string]
    def getConnectorArn: ZIO[Any, Nothing, __string] = ZIO.succeed(connectorArn)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest
  ) extends zio.aws.kafkaconnect.model.DeleteConnectorRequest.ReadOnly {
    override val connectorArn: __string = impl.connectorArn(): __string
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorRequest
  ): zio.aws.kafkaconnect.model.DeleteConnectorRequest.ReadOnly = new Wrapper(
    impl
  )
}
