package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.__string
import scala.jdk.CollectionConverters.*
final case class DeleteConnectorResponse(
    connectorArn: Optional[__string] = Optional.Absent,
    connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse = {
    import DeleteConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse
      .builder()
      .optionallyWith(connectorArn.map(value => value: java.lang.String))(
        _.connectorArn
      )
      .optionallyWith(connectorState.map(value => value.unwrap))(
        _.connectorState
      )
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly =
    zio.aws.kafkaconnect.model.DeleteConnectorResponse.wrap(buildAwsValue())
}
object DeleteConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.DeleteConnectorResponse =
      zio.aws.kafkaconnect.model.DeleteConnectorResponse(
        connectorArn.map(value => value),
        connectorState.map(value => value)
      )
    def connectorArn: Optional[__string]
    def connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState]
    def getConnectorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
    def getConnectorState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.ConnectorState] =
      AwsError.unwrapOptionField("connectorState", connectorState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse
  ) extends zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly {
    override val connectorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => value: __string)
    override val connectorState
        : Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorState())
        .map(value => zio.aws.kafkaconnect.model.ConnectorState.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DeleteConnectorResponse
  ): zio.aws.kafkaconnect.model.DeleteConnectorResponse.ReadOnly = new Wrapper(
    impl
  )
}
