package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{__timestampIso8601, __string}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeConnectorResponse(
    capacity: Optional[zio.aws.kafkaconnect.model.CapacityDescription] =
      Optional.Absent,
    connectorArn: Optional[__string] = Optional.Absent,
    connectorConfiguration: Optional[Map[__string, __string]] = Optional.Absent,
    connectorDescription: Optional[__string] = Optional.Absent,
    connectorName: Optional[__string] = Optional.Absent,
    connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      Optional.Absent,
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    currentVersion: Optional[__string] = Optional.Absent,
    kafkaCluster: Optional[zio.aws.kafkaconnect.model.KafkaClusterDescription] =
      Optional.Absent,
    kafkaClusterClientAuthentication: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
    ] = Optional.Absent,
    kafkaClusterEncryptionInTransit: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
    ] = Optional.Absent,
    kafkaConnectVersion: Optional[__string] = Optional.Absent,
    logDelivery: Optional[zio.aws.kafkaconnect.model.LogDeliveryDescription] =
      Optional.Absent,
    plugins: Optional[Iterable[zio.aws.kafkaconnect.model.PluginDescription]] =
      Optional.Absent,
    serviceExecutionRoleArn: Optional[__string] = Optional.Absent,
    stateDescription: Optional[zio.aws.kafkaconnect.model.StateDescription] =
      Optional.Absent,
    workerConfiguration: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationDescription
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse = {
    import DescribeConnectorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse
      .builder()
      .optionallyWith(capacity.map(value => value.buildAwsValue()))(_.capacity)
      .optionallyWith(connectorArn.map(value => value: java.lang.String))(
        _.connectorArn
      )
      .optionallyWith(
        connectorConfiguration.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.connectorConfiguration)
      .optionallyWith(
        connectorDescription.map(value => value: java.lang.String)
      )(_.connectorDescription)
      .optionallyWith(connectorName.map(value => value: java.lang.String))(
        _.connectorName
      )
      .optionallyWith(connectorState.map(value => value.unwrap))(
        _.connectorState
      )
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(currentVersion.map(value => value: java.lang.String))(
        _.currentVersion
      )
      .optionallyWith(kafkaCluster.map(value => value.buildAwsValue()))(
        _.kafkaCluster
      )
      .optionallyWith(
        kafkaClusterClientAuthentication.map(value => value.buildAwsValue())
      )(_.kafkaClusterClientAuthentication)
      .optionallyWith(
        kafkaClusterEncryptionInTransit.map(value => value.buildAwsValue())
      )(_.kafkaClusterEncryptionInTransit)
      .optionallyWith(
        kafkaConnectVersion.map(value => value: java.lang.String)
      )(_.kafkaConnectVersion)
      .optionallyWith(logDelivery.map(value => value.buildAwsValue()))(
        _.logDelivery
      )
      .optionallyWith(
        plugins.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.plugins)
      .optionallyWith(
        serviceExecutionRoleArn.map(value => value: java.lang.String)
      )(_.serviceExecutionRoleArn)
      .optionallyWith(stateDescription.map(value => value.buildAwsValue()))(
        _.stateDescription
      )
      .optionallyWith(workerConfiguration.map(value => value.buildAwsValue()))(
        _.workerConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly =
    zio.aws.kafkaconnect.model.DescribeConnectorResponse.wrap(buildAwsValue())
}
object DescribeConnectorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.DescribeConnectorResponse =
      zio.aws.kafkaconnect.model.DescribeConnectorResponse(
        capacity.map(value => value.asEditable),
        connectorArn.map(value => value),
        connectorConfiguration.map(value => value),
        connectorDescription.map(value => value),
        connectorName.map(value => value),
        connectorState.map(value => value),
        creationTime.map(value => value),
        currentVersion.map(value => value),
        kafkaCluster.map(value => value.asEditable),
        kafkaClusterClientAuthentication.map(value => value.asEditable),
        kafkaClusterEncryptionInTransit.map(value => value.asEditable),
        kafkaConnectVersion.map(value => value),
        logDelivery.map(value => value.asEditable),
        plugins.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serviceExecutionRoleArn.map(value => value),
        stateDescription.map(value => value.asEditable),
        workerConfiguration.map(value => value.asEditable)
      )
    def capacity
        : Optional[zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly]
    def connectorArn: Optional[__string]
    def connectorConfiguration: Optional[Map[__string, __string]]
    def connectorDescription: Optional[__string]
    def connectorName: Optional[__string]
    def connectorState: Optional[zio.aws.kafkaconnect.model.ConnectorState]
    def creationTime: Optional[__timestampIso8601]
    def currentVersion: Optional[__string]
    def kafkaCluster
        : Optional[zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly]
    def kafkaClusterClientAuthentication: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly
    ]
    def kafkaClusterEncryptionInTransit: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly
    ]
    def kafkaConnectVersion: Optional[__string]
    def logDelivery
        : Optional[zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly]
    def plugins
        : Optional[List[zio.aws.kafkaconnect.model.PluginDescription.ReadOnly]]
    def serviceExecutionRoleArn: Optional[__string]
    def stateDescription
        : Optional[zio.aws.kafkaconnect.model.StateDescription.ReadOnly]
    def workerConfiguration: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly
    ]
    def getCapacity: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly
    ] = AwsError.unwrapOptionField("capacity", capacity)
    def getConnectorArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorArn", connectorArn)
    def getConnectorConfiguration: ZIO[Any, AwsError, Map[__string, __string]] =
      AwsError.unwrapOptionField(
        "connectorConfiguration",
        connectorConfiguration
      )
    def getConnectorDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorDescription", connectorDescription)
    def getConnectorName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("connectorName", connectorName)
    def getConnectorState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.ConnectorState] =
      AwsError.unwrapOptionField("connectorState", connectorState)
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCurrentVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("currentVersion", currentVersion)
    def getKafkaCluster: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly
    ] = AwsError.unwrapOptionField("kafkaCluster", kafkaCluster)
    def getKafkaClusterClientAuthentication: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kafkaClusterClientAuthentication",
      kafkaClusterClientAuthentication
    )
    def getKafkaClusterEncryptionInTransit: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kafkaClusterEncryptionInTransit",
      kafkaClusterEncryptionInTransit
    )
    def getKafkaConnectVersion: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("kafkaConnectVersion", kafkaConnectVersion)
    def getLogDelivery: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly
    ] = AwsError.unwrapOptionField("logDelivery", logDelivery)
    def getPlugins: ZIO[Any, AwsError, List[
      zio.aws.kafkaconnect.model.PluginDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("plugins", plugins)
    def getServiceExecutionRoleArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("serviceExecutionRoleArn", serviceExecutionRoleArn)
    def getStateDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.StateDescription.ReadOnly
    ] = AwsError.unwrapOptionField("stateDescription", stateDescription)
    def getWorkerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly
    ] = AwsError.unwrapOptionField("workerConfiguration", workerConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse
  ) extends zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly {
    override val capacity
        : Optional[zio.aws.kafkaconnect.model.CapacityDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.capacity())
        .map(value =>
          zio.aws.kafkaconnect.model.CapacityDescription.wrap(value)
        )
    override val connectorArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorArn())
      .map(value => value: __string)
    override val connectorConfiguration: Optional[Map[__string, __string]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorConfiguration())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: __string) -> (value: __string)
            })
            .toMap
        )
    override val connectorDescription: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorDescription())
        .map(value => value: __string)
    override val connectorName: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.connectorName())
      .map(value => value: __string)
    override val connectorState
        : Optional[zio.aws.kafkaconnect.model.ConnectorState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectorState())
        .map(value => zio.aws.kafkaconnect.model.ConnectorState.wrap(value))
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val currentVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.currentVersion())
      .map(value => value: __string)
    override val kafkaCluster: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaCluster())
      .map(value =>
        zio.aws.kafkaconnect.model.KafkaClusterDescription.wrap(value)
      )
    override val kafkaClusterClientAuthentication: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaClusterClientAuthentication())
      .map(value =>
        zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
          .wrap(value)
      )
    override val kafkaClusterEncryptionInTransit: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaClusterEncryptionInTransit())
      .map(value =>
        zio.aws.kafkaconnect.model.KafkaClusterEncryptionInTransitDescription
          .wrap(value)
      )
    override val kafkaConnectVersion: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.kafkaConnectVersion())
      .map(value => value: __string)
    override val logDelivery
        : Optional[zio.aws.kafkaconnect.model.LogDeliveryDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logDelivery())
        .map(value =>
          zio.aws.kafkaconnect.model.LogDeliveryDescription.wrap(value)
        )
    override val plugins: Optional[
      List[zio.aws.kafkaconnect.model.PluginDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.plugins())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kafkaconnect.model.PluginDescription.wrap(item)
        }.toList
      )
    override val serviceExecutionRoleArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceExecutionRoleArn())
        .map(value => value: __string)
    override val stateDescription
        : Optional[zio.aws.kafkaconnect.model.StateDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateDescription())
        .map(value => zio.aws.kafkaconnect.model.StateDescription.wrap(value))
    override val workerConfiguration: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workerConfiguration())
      .map(value =>
        zio.aws.kafkaconnect.model.WorkerConfigurationDescription.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeConnectorResponse
  ): zio.aws.kafkaconnect.model.DescribeConnectorResponse.ReadOnly =
    new Wrapper(impl)
}
