package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeCustomPluginResponse(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    customPluginArn: Optional[__string] = Optional.Absent,
    customPluginState: Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    latestRevision: Optional[
      zio.aws.kafkaconnect.model.CustomPluginRevisionSummary
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    stateDescription: Optional[zio.aws.kafkaconnect.model.StateDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse = {
    import DescribeCustomPluginResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(customPluginArn.map(value => value: java.lang.String))(
        _.customPluginArn
      )
      .optionallyWith(customPluginState.map(value => value.unwrap))(
        _.customPluginState
      )
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(stateDescription.map(value => value.buildAwsValue()))(
        _.stateDescription
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly =
    zio.aws.kafkaconnect.model.DescribeCustomPluginResponse
      .wrap(buildAwsValue())
}
object DescribeCustomPluginResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.DescribeCustomPluginResponse =
      zio.aws.kafkaconnect.model.DescribeCustomPluginResponse(
        creationTime.map(value => value),
        customPluginArn.map(value => value),
        customPluginState.map(value => value),
        description.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        stateDescription.map(value => value.asEditable)
      )
    def creationTime: Optional[__timestampIso8601]
    def customPluginArn: Optional[__string]
    def customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState]
    def description: Optional[__string]
    def latestRevision: Optional[
      zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly
    ]
    def name: Optional[__string]
    def stateDescription
        : Optional[zio.aws.kafkaconnect.model.StateDescription.ReadOnly]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getCustomPluginArn: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("customPluginArn", customPluginArn)
    def getCustomPluginState
        : ZIO[Any, AwsError, zio.aws.kafkaconnect.model.CustomPluginState] =
      AwsError.unwrapOptionField("customPluginState", customPluginState)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getStateDescription: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.StateDescription.ReadOnly
    ] = AwsError.unwrapOptionField("stateDescription", stateDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse
  ) extends zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val customPluginArn: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.customPluginArn())
      .map(value => value: __string)
    override val customPluginState
        : Optional[zio.aws.kafkaconnect.model.CustomPluginState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customPluginState())
        .map(value => zio.aws.kafkaconnect.model.CustomPluginState.wrap(value))
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val latestRevision: Optional[
      zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRevision())
      .map(value =>
        zio.aws.kafkaconnect.model.CustomPluginRevisionSummary.wrap(value)
      )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val stateDescription
        : Optional[zio.aws.kafkaconnect.model.StateDescription.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stateDescription())
        .map(value => zio.aws.kafkaconnect.model.StateDescription.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeCustomPluginResponse
  ): zio.aws.kafkaconnect.model.DescribeCustomPluginResponse.ReadOnly =
    new Wrapper(impl)
}
