package zio.aws.kafkaconnect.model
import zio.aws.kafkaconnect.model.primitives.{__string, __timestampIso8601}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeWorkerConfigurationResponse(
    creationTime: Optional[__timestampIso8601] = Optional.Absent,
    description: Optional[__string] = Optional.Absent,
    latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription
    ] = Optional.Absent,
    name: Optional[__string] = Optional.Absent,
    workerConfigurationArn: Optional[__string] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse = {
    import DescribeWorkerConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse
      .builder()
      .optionallyWith(creationTime.map(value => value: Instant))(_.creationTime)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(latestRevision.map(value => value.buildAwsValue()))(
        _.latestRevision
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(
        workerConfigurationArn.map(value => value: java.lang.String)
      )(_.workerConfigurationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly =
    zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse
      .wrap(buildAwsValue())
}
object DescribeWorkerConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse =
      zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse(
        creationTime.map(value => value),
        description.map(value => value),
        latestRevision.map(value => value.asEditable),
        name.map(value => value),
        workerConfigurationArn.map(value => value)
      )
    def creationTime: Optional[__timestampIso8601]
    def description: Optional[__string]
    def latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly
    ]
    def name: Optional[__string]
    def workerConfigurationArn: Optional[__string]
    def getCreationTime: ZIO[Any, AwsError, __timestampIso8601] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getDescription: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("description", description)
    def getLatestRevision: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly
    ] = AwsError.unwrapOptionField("latestRevision", latestRevision)
    def getName: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("name", name)
    def getWorkerConfigurationArn: ZIO[Any, AwsError, __string] = AwsError
      .unwrapOptionField("workerConfigurationArn", workerConfigurationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse
  ) extends zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly {
    override val creationTime: Optional[__timestampIso8601] =
      zio.aws.core.internal
        .optionalFromNullable(impl.creationTime())
        .map(value => value: __timestampIso8601)
    override val description: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: __string)
    override val latestRevision: Optional[
      zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.latestRevision())
      .map(value =>
        zio.aws.kafkaconnect.model.WorkerConfigurationRevisionDescription
          .wrap(value)
      )
    override val name: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: __string)
    override val workerConfigurationArn: Optional[__string] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workerConfigurationArn())
        .map(value => value: __string)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.DescribeWorkerConfigurationResponse
  ): zio.aws.kafkaconnect.model.DescribeWorkerConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
