package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class FirehoseLogDelivery(
    deliveryStream: Optional[__string] = Optional.Absent,
    enabled: __boolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery = {
    import FirehoseLogDelivery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery
      .builder()
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .enabled(enabled: java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly =
    zio.aws.kafkaconnect.model.FirehoseLogDelivery.wrap(buildAwsValue())
}
object FirehoseLogDelivery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.FirehoseLogDelivery =
      zio.aws.kafkaconnect.model
        .FirehoseLogDelivery(deliveryStream.map(value => value), enabled)
    def deliveryStream: Optional[__string]
    def enabled: __boolean
    def getDeliveryStream: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
    def getEnabled: ZIO[Any, Nothing, __boolean] = ZIO.succeed(enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery
  ) extends zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly {
    override val deliveryStream: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: __string)
    override val enabled: __boolean = impl.enabled(): __boolean
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDelivery
  ): zio.aws.kafkaconnect.model.FirehoseLogDelivery.ReadOnly = new Wrapper(impl)
}
