package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.kafkaconnect.model.primitives.{__boolean, __string}
import scala.jdk.CollectionConverters.*
final case class FirehoseLogDeliveryDescription(
    deliveryStream: Optional[__string] = Optional.Absent,
    enabled: Optional[__boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription = {
    import FirehoseLogDeliveryDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription
      .builder()
      .optionallyWith(deliveryStream.map(value => value: java.lang.String))(
        _.deliveryStream
      )
      .optionallyWith(enabled.map(value => value: java.lang.Boolean))(_.enabled)
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly =
    zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription
      .wrap(buildAwsValue())
}
object FirehoseLogDeliveryDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription =
      zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription(
        deliveryStream.map(value => value),
        enabled.map(value => value)
      )
    def deliveryStream: Optional[__string]
    def enabled: Optional[__boolean]
    def getDeliveryStream: ZIO[Any, AwsError, __string] =
      AwsError.unwrapOptionField("deliveryStream", deliveryStream)
    def getEnabled: ZIO[Any, AwsError, __boolean] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription
  ) extends zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly {
    override val deliveryStream: Optional[__string] = zio.aws.core.internal
      .optionalFromNullable(impl.deliveryStream())
      .map(value => value: __string)
    override val enabled: Optional[__boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => value: __boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.FirehoseLogDeliveryDescription
  ): zio.aws.kafkaconnect.model.FirehoseLogDeliveryDescription.ReadOnly =
    new Wrapper(impl)
}
