package zio.aws.kafkaconnect.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class KafkaClusterClientAuthenticationDescription(
    authenticationType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription = {
    import KafkaClusterClientAuthenticationDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
      .builder()
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly =
    zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
      .wrap(buildAwsValue())
}
object KafkaClusterClientAuthenticationDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription =
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription(
        authenticationType.map(value => value)
      )
    def authenticationType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    ]
    def getAuthenticationType: ZIO[
      Any,
      AwsError,
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    ] = AwsError.unwrapOptionField("authenticationType", authenticationType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
  ) extends zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly {
    override val authenticationType: Optional[
      zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.authenticationType())
      .map(value =>
        zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationDescription
  ): zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationDescription.ReadOnly =
    new Wrapper(impl)
}
