package zio.aws.kafkaconnect.model
import scala.jdk.CollectionConverters.*
sealed trait KafkaClusterClientAuthenticationType {
  def unwrap: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType
}
object KafkaClusterClientAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType
  ): zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType =
    value match {
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.NONE =>
        val r = NONE
        r
      case software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.IAM =>
        val r = IAM
        r
    }
  case object unknownToSdkVersion
      extends zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object NONE
      extends zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.NONE
  }
  case object IAM
      extends zio.aws.kafkaconnect.model.KafkaClusterClientAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType =
      software.amazon.awssdk.services.kafkaconnect.model.KafkaClusterClientAuthenticationType.IAM
  }
}
